/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CosmotePostEventRequest {
    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "integration";
    private final String KEY_METHOD = "method";
    private final String KEY_METHOD_VALUE = "postEvent";
    private final String KEY_DATA = "data";
    private final String KEY_PARAMETERS = "parameters";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mUserMsisdn = "";
    private String mCommunicationUuid = "";
    private String mOfferAudienceLevel = "";
    private String mUACIOfferTrackingCode = "";
    private String mOfferCode1 = "";
    private String mScore = "";
    private String mZone = "";
    private String mWave = "";
    private String mValidity = "";
    private String mTreatmentCode = "";

    public CosmotePostEventRequest() {
        this.mFilters = new HashMap();
    }

    public CosmotePostEventRequest(CosmotePostEventRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CosmotePostEventRequest) {
            CosmotePostEventRequest other = (CosmotePostEventRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public CosmotePostEventRequest setCommunicationUuid(String communicationUuid) {
        this.mCommunicationUuid = communicationUuid;
        return this;
    }

    public CosmotePostEventRequest setUserMsisdn(String userMsisdn) {
        this.mUserMsisdn = userMsisdn;
        return this;
    }

    public CosmotePostEventRequest setOfferAudienceLevel(String offerAudienceLevel) {
        this.mOfferAudienceLevel = offerAudienceLevel;
        return this;
    }

    public CosmotePostEventRequest setUACIOfferTrackingCode(String uaciOfferTrackingCode) {
        this.mUACIOfferTrackingCode = uaciOfferTrackingCode;
        return this;
    }

    public CosmotePostEventRequest setOfferCode1(String offerCode1) {
        this.mOfferCode1 = offerCode1;
        return this;
    }

    public CosmotePostEventRequest setScore(String score) {
        this.mScore = score;
        return this;
    }

    public CosmotePostEventRequest setZone(String zone) {
        this.mZone = zone;
        return this;
    }

    public CosmotePostEventRequest setWave(String wave) {
        this.mWave = wave;
        return this;
    }

    public CosmotePostEventRequest setValidity(String validity) {
        this.mValidity = validity;
        return this;
    }

    public CosmotePostEventRequest setTreatmentCode(String treatmentCode) {
        this.mTreatmentCode = treatmentCode;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public CosmotePostEventRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public CosmotePostEventRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"integration");
                extraJson.putOpt("method", (Object)"postEvent");
                JSONObject data = new JSONObject();
                data.putOpt("InteractiveChannel", (Object)"COSMOTE_OMNI");
                data.putOpt("InteractionPoint", (Object)this.mZone);
                data.putOpt("Session_ID", (Object)this.mCommunicationUuid);
                data.putOpt("OfferAudienceLevel", (Object)this.mOfferAudienceLevel);
                data.putOpt("MSISDN", (Object)(this.mOfferAudienceLevel.equals("msisdn") ? this.mUserMsisdn : ""));
                data.putOpt("GUID", (Object)"");
                JSONArray parameters = new JSONArray();
                JSONObject param1 = new JSONObject();
                param1.putOpt("Name", (Object)"UACIOfferTrackingCode");
                param1.putOpt("Value", (Object)this.mUACIOfferTrackingCode);
                param1.putOpt("Type", (Object)"string");
                parameters.put((Object)param1);
                JSONObject param2 = new JSONObject();
                param2.putOpt("Name", (Object)"UACICustomLoggerTableName");
                param2.putOpt("Value", (Object)"VW_WHITELIST");
                param2.putOpt("Type", (Object)"string");
                parameters.put((Object)param2);
                JSONObject param3 = new JSONObject();
                param3.putOpt("Name", (Object)"MSISDN");
                param3.putOpt("Value", (Object)this.mUserMsisdn);
                param3.putOpt("Type", (Object)"string");
                parameters.put((Object)param3);
                JSONObject param4 = new JSONObject();
                param4.putOpt("Name", (Object)"OFFERCODE1");
                param4.putOpt("Value", (Object)this.mOfferCode1);
                param4.putOpt("Type", (Object)"string");
                parameters.put((Object)param4);
                JSONObject param5 = new JSONObject();
                param5.putOpt("Name", (Object)"SCORE");
                param5.putOpt("Value", (Object)this.mScore);
                param5.putOpt("Type", (Object)"INT");
                parameters.put((Object)param5);
                JSONObject param6 = new JSONObject();
                param6.putOpt("Name", (Object)"PREDICATE");
                param6.putOpt("Value", (Object)"0");
                param6.putOpt("Type", (Object)"string");
                parameters.put((Object)param6);
                JSONObject param7 = new JSONObject();
                param7.putOpt("Name", (Object)"ZONE");
                param7.putOpt("Value", (Object)this.mZone);
                param7.putOpt("Type", (Object)"string");
                parameters.put((Object)param7);
                JSONObject param8 = new JSONObject();
                param8.putOpt("Name", (Object)"APPLICATIONNAME");
                param8.putOpt("Value", (Object)this.mZone);
                param8.putOpt("Type", (Object)"string");
                parameters.put((Object)param8);
                JSONObject param9 = new JSONObject();
                param9.putOpt("Name", (Object)"Session_ID");
                param9.putOpt("Value", (Object)this.mCommunicationUuid);
                param9.putOpt("Type", (Object)"string");
                parameters.put((Object)param9);
                JSONObject param10 = new JSONObject();
                param10.putOpt("Name", (Object)"CAMPAIGN_CODE");
                param10.putOpt("Value", (Object)"MCC_00006");
                param10.putOpt("Type", (Object)"string");
                parameters.put((Object)param10);
                JSONObject param11 = new JSONObject();
                param11.putOpt("Name", (Object)"CAMPAIGN_TYPE");
                param11.putOpt("Value", (Object)"Inbound");
                param11.putOpt("Type", (Object)"string");
                parameters.put((Object)param11);
                JSONObject param12 = new JSONObject();
                param12.putOpt("Name", (Object)"UACIResponseTypeCode");
                param12.putOpt("Value", (Object)"CON");
                param12.putOpt("Type", (Object)"string");
                parameters.put((Object)param12);
                JSONObject param13 = new JSONObject();
                param13.putOpt("Name", (Object)"CHANNEL");
                param13.putOpt("Value", (Object)"ONE_APP");
                param13.putOpt("Type", (Object)"string");
                parameters.put((Object)param13);
                JSONObject param14 = new JSONObject();
                param14.putOpt("Name", (Object)"WAVE");
                param14.putOpt("Value", (Object)this.mWave);
                param14.putOpt("Type", (Object)"string");
                parameters.put((Object)param14);
                JSONObject param15 = new JSONObject();
                param15.putOpt("Name", (Object)"RESPONSECHANNEL");
                param15.putOpt("Value", (Object)"ONE_APP");
                param15.putOpt("Type", (Object)"string");
                parameters.put((Object)param15);
                JSONObject param16 = new JSONObject();
                param16.putOpt("Name", (Object)"VALIDITY");
                param16.putOpt("Value", (Object)this.mValidity);
                param16.putOpt("Type", (Object)"INT");
                parameters.put((Object)param16);
                JSONObject param17 = new JSONObject();
                param17.putOpt("Name", (Object)"TREATMENT_CODE");
                param17.putOpt("Value", (Object)this.mTreatmentCode);
                param17.putOpt("Type", (Object)"string");
                parameters.put((Object)param17);
                JSONObject param18 = new JSONObject();
                param18.putOpt("Name", (Object)"EventName");
                param18.putOpt("Value", (Object)"INTEREST_P");
                param18.putOpt("Type", (Object)"string");
                parameters.put((Object)param18);
                data.putOpt("parameters", (Object)parameters);
                extraJson.putOpt("data", (Object)data);
                bodyJsonObject.putOpt("consumer_data", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_cosmote_post_event_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

