/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyAddAddressRequest {
    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "handle_addresses_new";
    private final String KEY_PROCESS = "process";
    private final String KEY_PROCESS_VALUE = "add";
    private final String KEY_DATA = "data";
    private final String KEY_FRIENDLY_NAME = "friendly_name";
    private final String KEY_ADDRESS_NAME = "address_name";
    private final String KEY_ADDRESS_NUMBER = "address_number";
    private final String KEY_POSTAL_CODE = "postal_code";
    private final String KEY_FLOOR_NUMBER = "floor_number";
    private final String KEY_DOORBELL = "doorbel";
    private final String KEY_REGION = "region";
    private final String KEY_LATITUDE = "latitude";
    private final String KEY_LONGITUTDE = "longitude";
    private final String KEY_NOTES = "notes";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mFriendlyName = "";
    private String mAddressName = "";
    private String mAddressNumber = "0";
    private String mPostalCode = "";
    private int mFloorNumber = 0;
    private String mDoorbell = "";
    private String mRegion = "";
    private String mLat = null;
    private String mLon = null;
    private String mNotes = "";

    public WarplyAddAddressRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyAddAddressRequest(WarplyAddAddressRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyAddAddressRequest) {
            WarplyAddAddressRequest other = (WarplyAddAddressRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyAddAddressRequest setFriendlyName(String friendlyName) {
        this.mFriendlyName = friendlyName;
        return this;
    }

    public WarplyAddAddressRequest setAddressName(String addressName) {
        this.mAddressName = addressName;
        return this;
    }

    public WarplyAddAddressRequest setAddressNumber(String addressNumber) {
        this.mAddressNumber = addressNumber;
        return this;
    }

    public WarplyAddAddressRequest setPostalCode(String postalCode) {
        this.mPostalCode = postalCode;
        return this;
    }

    public WarplyAddAddressRequest setFloorNumber(int floorNumber) {
        this.mFloorNumber = floorNumber;
        return this;
    }

    public WarplyAddAddressRequest setDoorbell(String doorbell) {
        this.mDoorbell = doorbell;
        return this;
    }

    public WarplyAddAddressRequest setRegion(String region) {
        this.mRegion = region;
        return this;
    }

    public WarplyAddAddressRequest setLatitude(String lat) {
        this.mLat = lat;
        return this;
    }

    public WarplyAddAddressRequest setLongitude(String lon) {
        this.mLon = lon;
        return this;
    }

    public WarplyAddAddressRequest setNotes(String notes) {
        this.mNotes = notes;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyAddAddressRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyAddAddressRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"handle_addresses_new");
                extraJson.putOpt("process", (Object)"add");
                JSONObject data = new JSONObject();
                data.putOpt("friendly_name", (Object)this.mFriendlyName);
                data.putOpt("address_name", (Object)this.mAddressName);
                data.putOpt("address_number", (Object)this.mAddressNumber);
                data.putOpt("postal_code", (Object)this.mPostalCode);
                data.putOpt("floor_number", (Object)this.mFloorNumber);
                data.putOpt("doorbel", (Object)this.mDoorbell);
                data.putOpt("region", (Object)this.mRegion);
                data.putOpt("latitude", (Object)this.mLat);
                data.putOpt("longitude", (Object)this.mLon);
                data.putOpt("notes", (Object)this.mNotes);
                extraJson.putOpt("data", (Object)data);
                bodyJsonObject.putOpt("consumer_data", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_add_address_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

