/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyAddCardRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "add_card";
    private final String KEY_CARD_ISSUER = "card_issuer";
    private final String KEY_CARD_NUMBER = "card_number";
    private final String KEY_CARD_HOLDER = "cardholder";
    private final String KEY_CARD_EXP_MONTH = "expiration_month";
    private final String KEY_CARD_EXP_YEAR = "expiration_year";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mCardIssuer = "";
    private String mCardNumber = "";
    private String mCardHolder = "";
    private String mCardExpMonth = "";
    private String mCardExpYear = "";

    public WarplyAddCardRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyAddCardRequest(WarplyAddCardRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyAddCardRequest) {
            WarplyAddCardRequest other = (WarplyAddCardRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyAddCardRequest setCardIssuer(String cardIssuer) {
        this.mCardIssuer = cardIssuer;
        return this;
    }

    public WarplyAddCardRequest setCardNumber(String cardNumber) {
        this.mCardNumber = cardNumber;
        return this;
    }

    public WarplyAddCardRequest setCardHolder(String cardHolder) {
        this.mCardHolder = cardHolder;
        return this;
    }

    public WarplyAddCardRequest setCardExpMonth(String cardExpMonth) {
        this.mCardExpMonth = cardExpMonth;
        return this;
    }

    public WarplyAddCardRequest setCardExpYear(String cardExpYear) {
        this.mCardExpYear = cardExpYear;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyAddCardRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyAddCardRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"add_card");
                bodyJsonObject.putOpt("card_issuer", (Object)this.mCardIssuer);
                bodyJsonObject.putOpt("card_number", (Object)this.mCardNumber);
                bodyJsonObject.putOpt("cardholder", (Object)this.mCardHolder);
                bodyJsonObject.putOpt("expiration_month", (Object)this.mCardExpMonth);
                bodyJsonObject.putOpt("expiration_year", (Object)this.mCardExpYear);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_add_card_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

