/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyChangePasswordRequest {
    private final String KEY_CHANNEL = "channel";
    private final String KEY_OLD_PASSWORD = "old_password";
    private final String KEY_NEW_PASSWORD = "new_password";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mOldPassword = "";
    private String mNewPassword = "";

    public WarplyChangePasswordRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyChangePasswordRequest(WarplyChangePasswordRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyChangePasswordRequest) {
            WarplyChangePasswordRequest other = (WarplyChangePasswordRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyChangePasswordRequest setOldPassword(String oldPassword) {
        this.mOldPassword = oldPassword;
        return this;
    }

    public WarplyChangePasswordRequest setNewPassword(String newPassword) {
        this.mNewPassword = newPassword;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyChangePasswordRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyChangePasswordRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("channel", (Object)"mobile");
                bodyJsonObject.putOpt("old_password", (Object)this.mOldPassword);
                bodyJsonObject.putOpt("new_password", (Object)this.mNewPassword);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_change_password_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

