/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyConsumerRequest {
    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "handle_user_details";
    private final String KEY_PROCESS = "process";
    private final String KEY_PROCESS_VALUE = "get";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;

    public WarplyConsumerRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyConsumerRequest(WarplyConsumerRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyConsumerRequest) {
            WarplyConsumerRequest other = (WarplyConsumerRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyConsumerRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyConsumerRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"handle_user_details");
                extraJson.putOpt("process", (Object)"get");
                bodyJsonObject.putOpt("consumer_data", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_consumer_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

