/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyContactRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "addContact";
    private final String KEY_SUBJECT = "contact_type";
    private final String KEY_NAME = "name";
    private final String KEY_EMAIL = "email";
    private final String KEY_MSISDN = "msisdn";
    private final String KEY_MESSAGE = "message";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mSubject = "";
    private String mName = "";
    private String mEmail = "";
    private String mMsisdn = "";
    private String mMessage = "";

    public WarplyContactRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyContactRequest(WarplyContactRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyContactRequest) {
            WarplyContactRequest other = (WarplyContactRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyContactRequest setContactSubject(String subject) {
        this.mSubject = subject;
        return this;
    }

    public WarplyContactRequest setContactName(String name) {
        this.mName = name;
        return this;
    }

    public WarplyContactRequest setContactEmail(String email) {
        this.mEmail = email;
        return this;
    }

    public WarplyContactRequest setContactNumber(String msisdn) {
        this.mMsisdn = msisdn;
        return this;
    }

    public WarplyContactRequest setContactMessage(String message) {
        this.mMessage = message;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyContactRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyContactRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"addContact");
                bodyJsonObject.putOpt("contact_type", (Object)(TextUtils.isEmpty((CharSequence)this.mSubject) ? "" : this.mSubject));
                bodyJsonObject.putOpt("name", (Object)(TextUtils.isEmpty((CharSequence)this.mName) ? "" : this.mName));
                bodyJsonObject.putOpt("email", (Object)(TextUtils.isEmpty((CharSequence)this.mEmail) ? "" : this.mEmail));
                bodyJsonObject.putOpt("msisdn", (Object)(TextUtils.isEmpty((CharSequence)this.mMsisdn) ? "" : this.mMsisdn));
                bodyJsonObject.putOpt("message", (Object)(TextUtils.isEmpty((CharSequence)this.mMessage) ? "" : this.mMessage));
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_contact_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

