/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyContentRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "retrieve_multilingual";
    private final String KEY_ACTIVE = "active";
    private final String KEY_LANGUAGE = "language";
    private final String KEY_CATEGORY = "category";
    private final String KEY_TAGS = "tags";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mContentCategory = "";
    private ArrayList<String> mTags = new ArrayList();
    private String mLanguage = WarplyProperty.getLanguage(Warply.getWarplyContext());

    public WarplyContentRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyContentRequest(WarplyContentRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyContentRequest) {
            WarplyContentRequest other = (WarplyContentRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyContentRequest setContentCategory(String contentCategory) {
        this.mContentCategory = contentCategory;
        return this;
    }

    public WarplyContentRequest setTags(ArrayList<String> tags) {
        this.mTags = tags;
        return this;
    }

    public WarplyContentRequest setLanguage(String lan) {
        this.mLanguage = lan;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyContentRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyContentRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"retrieve_multilingual");
                bodyJsonObject.putOpt("active", (Object)true);
                bodyJsonObject.putOpt("language", (Object)this.mLanguage);
                bodyJsonObject.putOpt("category", TextUtils.isEmpty((CharSequence)this.mContentCategory) ? JSONObject.NULL : this.mContentCategory);
                JSONArray jsArray = new JSONArray(this.mTags);
                bodyJsonObject.putOpt("tags", jsArray.length() == 0 ? JSONObject.NULL : jsArray);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_content_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

