/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyCosmoteUserRequest {
    private final String KEY_USER_ID = "user_identifier";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mGuid = "";

    public WarplyCosmoteUserRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyCosmoteUserRequest(WarplyCosmoteUserRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyCosmoteUserRequest) {
            WarplyCosmoteUserRequest other = (WarplyCosmoteUserRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyCosmoteUserRequest setGuid(String guid) {
        this.mGuid = guid;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyCosmoteUserRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyCosmoteUserRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("user_identifier", (Object)this.mGuid);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_cosmote_user_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

