/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyEditAddressRequest {
    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "handle_addresses_new";
    private final String KEY_PROCESS = "process";
    private final String KEY_PROCESS_VALUE = "edit";
    private final String KEY_DATA = "data";
    private final String KEY_FRIENDLY_NAME = "friendly_name";
    private final String KEY_ADDRESS_NAME = "address_name";
    private final String KEY_ADDRESS_NUMBER = "address_number";
    private final String KEY_POSTAL_CODE = "postal_code";
    private final String KEY_FLOOR_NUMBER = "floor_number";
    private final String KEY_DOORBELL = "doorbel";
    private final String KEY_REGION = "region";
    private final String KEY_LATITUDE = "latitude";
    private final String KEY_LONGITUTDE = "longitude";
    private final String KEY_NOTES = "notes";
    private final String KEY_UUID = "uuid";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mFriendlyName = "";
    private String mAddressName = "";
    private String mAddressNumber = "0";
    private String mPostalCode = "";
    private int mFloorNumber = 0;
    private String mDoorbell = "";
    private String mRegion = "";
    private String mLat = null;
    private String mLon = null;
    private String mNotes = "";
    private String mUuid = "";

    public WarplyEditAddressRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyEditAddressRequest(WarplyEditAddressRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyEditAddressRequest) {
            WarplyEditAddressRequest other = (WarplyEditAddressRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyEditAddressRequest setFriendlyName(String friendlyName) {
        this.mFriendlyName = friendlyName;
        return this;
    }

    public WarplyEditAddressRequest setAddressName(String addressName) {
        this.mAddressName = addressName;
        return this;
    }

    public WarplyEditAddressRequest setAddressNumber(String addressNumber) {
        this.mAddressNumber = addressNumber;
        return this;
    }

    public WarplyEditAddressRequest setPostalCode(String postalCode) {
        this.mPostalCode = postalCode;
        return this;
    }

    public WarplyEditAddressRequest setFloorNumber(int floorNumber) {
        this.mFloorNumber = floorNumber;
        return this;
    }

    public WarplyEditAddressRequest setDoorbell(String doorbell) {
        this.mDoorbell = doorbell;
        return this;
    }

    public WarplyEditAddressRequest setRegion(String region) {
        this.mRegion = region;
        return this;
    }

    public WarplyEditAddressRequest setLatitude(String lat) {
        this.mLat = lat;
        return this;
    }

    public WarplyEditAddressRequest setLongitude(String lon) {
        this.mLon = lon;
        return this;
    }

    public WarplyEditAddressRequest setNotes(String notes) {
        this.mNotes = notes;
        return this;
    }

    public WarplyEditAddressRequest setUuid(String uuid) {
        this.mUuid = uuid;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyEditAddressRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyEditAddressRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block10: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"handle_addresses_new");
                extraJson.putOpt("process", (Object)"edit");
                JSONObject data = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)this.mFriendlyName)) {
                    data.putOpt("friendly_name", (Object)this.mFriendlyName);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mAddressName)) {
                    data.putOpt("address_name", (Object)this.mAddressName);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mAddressNumber)) {
                    data.putOpt("address_number", (Object)this.mAddressNumber);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPostalCode)) {
                    data.putOpt("postal_code", (Object)this.mPostalCode);
                }
                if (!TextUtils.isEmpty((CharSequence)String.valueOf(this.mFloorNumber)) && !String.valueOf(this.mFloorNumber).equals("0")) {
                    data.putOpt("floor_number", (Object)this.mFloorNumber);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mDoorbell)) {
                    data.putOpt("doorbel", (Object)this.mDoorbell);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mRegion)) {
                    data.putOpt("region", (Object)this.mRegion);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mNotes)) {
                    data.putOpt("notes", (Object)this.mNotes);
                }
                data.putOpt("uuid", (Object)this.mUuid);
                extraJson.putOpt("data", (Object)data);
                bodyJsonObject.putOpt("consumer_data", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block10;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_edit_address_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

