/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyEditConsumerRequest {
    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "handle_user_details";
    private final String KEY_PROCESS = "process";
    private final String KEY_PROCESS_VALUE = "edit";
    private final String KEY_DEL_EMPTY = "del_empty";
    private final String KEY_DATA = "data";
    private final String KEY_FIRST_NAME = "firstname";
    private final String KEY_LAST_NAME = "lastname";
    private final String KEY_EMAIL = "email";
    private final String KEY_SALUTATION = "salutation";
    private final String KEY_MSISDN = "msisdn";
    private final String KEY_NICKNAME = "nickname";
    private final String KEY_GENDER = "gender";
    private final String KEY_BIRTHDAY = "birthday";
    private final String KEY_OPTIN = "optin";
    private final String KEY_NEWSLETTER = "newsletter";
    private final String KEY_SMS = "sms";
    private final String KEY_PERSON_NEWSLETTER = "segmentation";
    private final String KEY_PERSON_SMS = "sms_segmentation";
    private final String KEY_NAMEDAY = "nameday";
    private final String KEY_PROFILE_METADATA = "profile_metadata";
    private final String KEY_TAX_ID = "tax_id";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mFirstName = "";
    private String mLastName = "";
    private String mEmail = "";
    private String mSalutation = "";
    private String mMsisdn = "";
    private String mNickname = "";
    private String mGender = "";
    private String mBirthday = "";
    private boolean mNewsletter = false;
    private boolean mSms = false;
    private boolean mPersonalizedNewsletter = false;
    private boolean mPersonalizedSms = false;
    private boolean mOptin = false;
    private String mNameday = "";
    private boolean mHasProfileMetadata = false;
    private JSONObject mProfileMetadata = new JSONObject();
    private String mTaxId = "";

    public WarplyEditConsumerRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyEditConsumerRequest(WarplyEditConsumerRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyEditConsumerRequest) {
            WarplyEditConsumerRequest other = (WarplyEditConsumerRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyEditConsumerRequest setOptin(boolean optin) {
        this.mOptin = optin;
        return this;
    }

    public WarplyEditConsumerRequest setHasProfileMetadata(boolean hasProfileMetadata) {
        this.mHasProfileMetadata = hasProfileMetadata;
        return this;
    }

    public WarplyEditConsumerRequest setProfileMetadata(JSONObject profileMetadata) {
        this.mProfileMetadata = profileMetadata;
        return this;
    }

    public WarplyEditConsumerRequest setFirstName(String firstname) {
        this.mFirstName = firstname;
        return this;
    }

    public WarplyEditConsumerRequest setLastName(String lastname) {
        this.mLastName = lastname;
        return this;
    }

    public WarplyEditConsumerRequest setEmail(String email) {
        this.mEmail = email;
        return this;
    }

    public WarplyEditConsumerRequest setSalutation(String salutation) {
        this.mSalutation = salutation;
        return this;
    }

    public WarplyEditConsumerRequest setMsisdn(String msisdn) {
        this.mMsisdn = msisdn;
        return this;
    }

    public WarplyEditConsumerRequest setNickname(String nickname) {
        this.mNickname = nickname;
        return this;
    }

    public WarplyEditConsumerRequest setGender(String gender) {
        this.mGender = gender;
        return this;
    }

    public WarplyEditConsumerRequest setBirthDate(String birthDate) {
        this.mBirthday = birthDate;
        return this;
    }

    public WarplyEditConsumerRequest setNameday(String nameday) {
        this.mNameday = nameday;
        return this;
    }

    public WarplyEditConsumerRequest setNewsletter(boolean newsletter) {
        this.mNewsletter = newsletter;
        return this;
    }

    public WarplyEditConsumerRequest setSms(boolean sms) {
        this.mSms = sms;
        return this;
    }

    public WarplyEditConsumerRequest setPersonalizedNewsletter(boolean personalizedNewsletter) {
        this.mPersonalizedNewsletter = personalizedNewsletter;
        return this;
    }

    public WarplyEditConsumerRequest setPersonalizedSms(boolean personalizedSms) {
        this.mPersonalizedSms = personalizedSms;
        return this;
    }

    public WarplyEditConsumerRequest setTaxId(String taxId) {
        this.mTaxId = this.mTaxId;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyEditConsumerRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyEditConsumerRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block14: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"handle_user_details");
                extraJson.putOpt("process", (Object)"edit");
                extraJson.putOpt("del_empty", (Object)false);
                JSONObject data = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)this.mFirstName)) {
                    data.putOpt("firstname", (Object)this.mFirstName);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mLastName)) {
                    data.putOpt("lastname", (Object)this.mLastName);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mEmail)) {
                    data.putOpt("email", (Object)this.mEmail);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mSalutation)) {
                    data.putOpt("salutation", (Object)this.mSalutation);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mMsisdn)) {
                    data.putOpt("msisdn", (Object)this.mMsisdn);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mNickname)) {
                    data.putOpt("nickname", (Object)this.mNickname);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mGender)) {
                    data.putOpt("gender", (Object)this.mGender);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mBirthday)) {
                    data.putOpt("birthday", (Object)this.mBirthday);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mNameday)) {
                    data.putOpt("nameday", (Object)this.mNameday);
                }
                if (this.mOptin) {
                    JSONObject optin = new JSONObject();
                    optin.put("newsletter", this.mNewsletter);
                    optin.put("sms", this.mSms);
                    optin.put("segmentation", this.mPersonalizedNewsletter);
                    optin.put("sms_segmentation", this.mPersonalizedSms);
                    data.putOpt("optin", (Object)optin);
                }
                if (this.mHasProfileMetadata) {
                    data.putOpt("profile_metadata", (Object)this.mProfileMetadata);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mTaxId)) {
                    data.putOpt("tax_id", (Object)this.mTaxId);
                }
                extraJson.putOpt("data", (Object)data);
                bodyJsonObject.putOpt("consumer_data", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block14;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_edit_consumer_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

