/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyForgotPasswordRequest {
    private final String KEY_CHANNEL = "channel";
    private final String KEY_ID = "id";
    private final String KEY_APP_UUID = "app_uuid";
    private final String KEY_CONF_CODE = "conf_code";
    private final String KEY_OTP_UUID = "otp_uuid";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mId = "";
    private String mOtp = "";
    private String mOtpUuid = "";

    public WarplyForgotPasswordRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyForgotPasswordRequest(WarplyForgotPasswordRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyForgotPasswordRequest) {
            WarplyForgotPasswordRequest other = (WarplyForgotPasswordRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyForgotPasswordRequest setId(String id2) {
        this.mId = id2;
        return this;
    }

    public WarplyForgotPasswordRequest setOtp(String otp) {
        this.mOtp = otp;
        return this;
    }

    public WarplyForgotPasswordRequest setOtpUuid(String otpuuid) {
        this.mOtpUuid = otpuuid;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyForgotPasswordRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyForgotPasswordRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block3: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("channel", (Object)"mobile");
                bodyJsonObject.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
                bodyJsonObject.putOpt("id", (Object)this.mId);
                if (!TextUtils.isEmpty((CharSequence)this.mOtp)) {
                    bodyJsonObject.putOpt("conf_code", (Object)this.mOtp);
                    bodyJsonObject.putOpt("otp_uuid", (Object)this.mOtpUuid);
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_forgot_password_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

