/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyGetCampaignsRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "retrieve";
    private final String KEY_LANGUAGE = "language";
    private final String KEY_FILTERS = "filters";
    private JSONObject mFilters = new JSONObject();
    private long mCacheUpdateInterval = 0L;
    private String mLanguage = WarplyProperty.getLanguage(Warply.getWarplyContext());

    public WarplyGetCampaignsRequest() {
        this.mFilters = new JSONObject();
    }

    public WarplyGetCampaignsRequest(WarplyGetCampaignsRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyGetCampaignsRequest) {
            WarplyGetCampaignsRequest other = (WarplyGetCampaignsRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyGetCampaignsRequest setLanguage(String language) {
        this.mLanguage = language;
        return this;
    }

    public WarplyGetCampaignsRequest setFilters(JSONObject filters) {
        this.mFilters = filters;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyGetCampaignsRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyGetCampaignsRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block4: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"retrieve");
                bodyJsonObject.putOpt("language", (Object)this.mLanguage);
                if (this.mFilters != null && this.mFilters.length() > 0) {
                    bodyJsonObject.putOpt("filters", (Object)this.mFilters);
                } else {
                    bodyJsonObject.putOpt("filters", (Object)new JSONObject());
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.length() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_get_campaigns_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

