/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyGetCouponsetsRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "retrieve_multilingual";
    private final String KEY_ACTIVE = "active";
    private final String KEY_VISIBLE = "visible";
    private final String KEY_LANGUAGE = "language";
    private final String KEY_UUIDS = "uuids";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private boolean mActive = true;
    private boolean mVisible = true;
    private ArrayList<String> mUuids = new ArrayList();
    private String mLanguage = WarplyProperty.getLanguage(Warply.getWarplyContext());

    public WarplyGetCouponsetsRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyGetCouponsetsRequest(WarplyGetCouponsetsRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyGetCouponsetsRequest) {
            WarplyGetCouponsetsRequest other = (WarplyGetCouponsetsRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyGetCouponsetsRequest setActive(boolean active) {
        this.mActive = active;
        return this;
    }

    public WarplyGetCouponsetsRequest setVisible(boolean visible) {
        this.mVisible = visible;
        return this;
    }

    public WarplyGetCouponsetsRequest setUuids(ArrayList<String> uuids) {
        this.mUuids = uuids;
        return this;
    }

    public WarplyGetCouponsetsRequest setLanguage(String language) {
        this.mLanguage = language;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyGetCouponsetsRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyGetCouponsetsRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block3: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"retrieve_multilingual");
                bodyJsonObject.putOpt("active", (Object)this.mActive);
                bodyJsonObject.putOpt("visible", (Object)this.mVisible);
                bodyJsonObject.putOpt("language", (Object)(TextUtils.isEmpty((CharSequence)this.mLanguage) ? "el" : this.mLanguage));
                if (this.mUuids != null && this.mUuids.size() > 0) {
                    bodyJsonObject.putOpt("uuids", (Object)new JSONArray(this.mUuids));
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_get_couponsets_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

