/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyInboxRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_FILTER = "filter";
    private final String KEY_FILTER_VALUE = "value";
    private final String ACTION_GET_INBOX = "get_inbox";
    private static final String FILTER_MESSAGE = "message";
    private static final String FILTER_UUID = "session_uuid";
    private static final String FILTER_OFFER_MESSAGE = "offer_message";
    private static final String FILTER_OFFER_CATEGORY = "offer_category";
    private static final String FILTER_CAMPAIGN_TYPE = "campaign_type";
    private static final String FILTER_SORTING = "sorting";
    private static final String FILTER_DISPLAY_TYPE = "display_type";
    private static final String FILTER_EXTRA_FIELDS = "extra_fields";
    private static final String FILTER_EXPIRED = "expired";
    private static final String FILTER_DELIVERY_METHOD = "delivery_method";
    private static final String VALUE_INAPP = "inapp";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;

    public WarplyInboxRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyInboxRequest(WarplyInboxRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyInboxRequest) {
            WarplyInboxRequest other = (WarplyInboxRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyInboxRequest addMessageFilter(String message) {
        this.mFilters.put(FILTER_MESSAGE, message);
        return this;
    }

    public WarplyInboxRequest addUuidFilter(String uuid) {
        this.mFilters.put(FILTER_UUID, uuid);
        return this;
    }

    public WarplyInboxRequest addOfferMessageFilter(String offerMessage) {
        this.mFilters.put(FILTER_OFFER_MESSAGE, offerMessage);
        return this;
    }

    public WarplyInboxRequest addOfferCategoryFilter(String offerCategory) {
        this.mFilters.put(FILTER_OFFER_CATEGORY, offerCategory);
        return this;
    }

    public WarplyInboxRequest addCampaignTypeFilter(String campaignType) {
        this.mFilters.put(FILTER_CAMPAIGN_TYPE, campaignType);
        return this;
    }

    public WarplyInboxRequest addSortingFilter(String sorting) {
        this.mFilters.put(FILTER_SORTING, sorting);
        return this;
    }

    public WarplyInboxRequest addDisplayTypeFilter(DisplayType displayType) {
        this.mFilters.put(FILTER_DISPLAY_TYPE, displayType.getValue());
        return this;
    }

    public WarplyInboxRequest addExtraFieldFilter(String extra) {
        this.mFilters.put(FILTER_EXTRA_FIELDS, extra);
        return this;
    }

    public WarplyInboxRequest addExpireTypeFilter(String expired) {
        this.mFilters.put(FILTER_EXPIRED, expired);
        return this;
    }

    public WarplyInboxRequest addCustomFilter(String key, String extra) {
        this.mFilters.put(key, extra);
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyInboxRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyInboxRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject offersJsonObject;
        block5: {
            offersJsonObject = new JSONObject();
            try {
                offersJsonObject.putOpt("action", (Object)"get_inbox");
                if (this.mFilters != null && this.mFilters.size() > 0) {
                    JSONArray filterJsonArray = new JSONArray();
                    for (Map.Entry<String, String> entry : this.mFilters.entrySet()) {
                        if (entry.getValue().equals("true") || entry.getValue().equals("false")) {
                            offersJsonObject.put(FILTER_EXPIRED, (Object)Boolean.valueOf(entry.getValue()));
                            continue;
                        }
                        JSONObject filterJson = new JSONObject();
                        filterJson.put("filter", (Object)entry.getKey());
                        filterJson.put("value", (Object)entry.getValue());
                        filterJsonArray.put((Object)filterJson);
                    }
                    offersJsonObject.put("filter", (Object)filterJsonArray);
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        return offersJsonObject;
    }

    public JSONObject toJsonInApp() {
        JSONObject offersJsonObject;
        block5: {
            offersJsonObject = new JSONObject();
            try {
                offersJsonObject.putOpt("action", (Object)"get_inbox");
                offersJsonObject.putOpt("filter", (Object)FILTER_DELIVERY_METHOD);
                offersJsonObject.putOpt("value", (Object)VALUE_INAPP);
                if (this.mFilters != null && this.mFilters.size() > 0) {
                    JSONArray filterJsonArray = new JSONArray();
                    for (Map.Entry<String, String> entry : this.mFilters.entrySet()) {
                        if (entry.getValue().equals("true") || entry.getValue().equals("false")) {
                            offersJsonObject.put(FILTER_EXPIRED, (Object)Boolean.valueOf(entry.getValue()));
                            continue;
                        }
                        JSONObject filterJson = new JSONObject();
                        filterJson.put("filter", (Object)entry.getKey());
                        filterJson.put("value", (Object)entry.getValue());
                        filterJsonArray.put((Object)filterJson);
                    }
                    offersJsonObject.put("filter", (Object)filterJsonArray);
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        return offersJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_inbox_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }

    public static enum DisplayType {
        LIST("list"),
        FEED("feed"),
        TILE("tile"),
        FULL_PAGE("full_page"),
        HALF_PAGE("half_page");

        private String value;

        private DisplayType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

