/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyIntegrationRequest {
    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "integration";
    private final String KEY_DATA = "data";
    private final String KEY_METHOD = "method";
    private final String KEY_METHOD_VALUE = "consumer_extra_data";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private boolean mIsNonTelco = false;
    private boolean mHasAcceptedConsent = false;
    private String mGuid = "";
    private String mLanguage = "";
    private ArrayList<String> mPhoneList = new ArrayList();

    public WarplyIntegrationRequest() {
        this.mFilters = new HashMap();
        this.mIsNonTelco = false;
        this.mHasAcceptedConsent = false;
        this.mGuid = "";
        this.mPhoneList = new ArrayList();
        this.mLanguage = "";
    }

    public WarplyIntegrationRequest(WarplyIntegrationRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyIntegrationRequest) {
            WarplyIntegrationRequest other = (WarplyIntegrationRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyIntegrationRequest setIsNoTelco(boolean isNonTelco) {
        this.mIsNonTelco = isNonTelco;
        return this;
    }

    public WarplyIntegrationRequest setHasAcceptedConsent(boolean hasAcceptedConsent) {
        this.mHasAcceptedConsent = hasAcceptedConsent;
        return this;
    }

    public WarplyIntegrationRequest setMsisdnList(ArrayList<String> phoneList) {
        this.mPhoneList = phoneList;
        return this;
    }

    public WarplyIntegrationRequest setGuid(String guid) {
        this.mGuid = guid;
        return this;
    }

    public WarplyIntegrationRequest setLanguage(String language) {
        this.mLanguage = language;
        return this;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyIntegrationRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyIntegrationRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"integration");
                extraJson.putOpt("method", (Object)"consumer_extra_data");
                JSONObject data = new JSONObject();
                data.putOpt("nonTelco", (Object)this.mIsNonTelco);
                data.putOpt("acceptedConsent", (Object)this.mHasAcceptedConsent);
                data.putOpt("msisdnList", (Object)new JSONArray(this.mPhoneList));
                data.putOpt("guid", (Object)this.mGuid);
                data.putOpt("language", (Object)this.mLanguage);
                extraJson.putOpt("data", (Object)data);
                bodyJsonObject.putOpt("consumer_data", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_integration_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

