/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.content.Context;
import android.text.format.DateFormat;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.volley.AuthFailureError;
import ly.warp.sdk.io.volley.NetworkResponse;
import ly.warp.sdk.io.volley.ParseError;
import ly.warp.sdk.io.volley.Response;
import ly.warp.sdk.io.volley.toolbox.HttpHeaderParser;
import ly.warp.sdk.io.volley.toolbox.JsonRequest;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyJsonArrayRequest
extends JsonRequest<JSONObject> {
    public WarplyJsonArrayRequest(int method, String url, JSONArray data, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(method, url, data == null ? null : data.toString(), listener, errorListener);
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        HashMap<String, String> headers = new HashMap<String, String>();
        Context context = Warply.getWarplyContext();
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        headers.put("loyalty-bundle-id", "android:" + context.getPackageName());
        headers.put("loyalty-date", timeStamp);
        headers.put("unique-device-id", new WarplyDeviceInfoCollector(context).getUniqueDeviceId());
        headers.put("channel", "mobile");
        if (WarpUtils.isRegisteredWarply(context)) {
            String apiKey = WarpUtils.getApiKey(context);
            String webId = WarpUtils.getWebId(context);
            headers.put("loyalty-web-id", webId);
            headers.put("loyalty-signature", WarpUtils.produceSignature(apiKey + timeStamp));
        }
        return headers;
    }

    @Override
    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
            return Response.success(new JSONObject(jsonString), HttpHeaderParser.parseCacheHeaders(response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error(new ParseError(e));
        }
        catch (JSONException je) {
            return Response.error(new ParseError(je));
        }
    }
}

