/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyLoginRequest {
    private final String KEY_ID = "id";
    private final String KEY_PASSWORD = "password";
    private final String KEY_WEB_ID = "web_id";
    private final String KEY_APP_UUID = "app_uuid";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mId = "";
    private String mPassword = "";

    public WarplyLoginRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyLoginRequest(WarplyLoginRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyLoginRequest) {
            WarplyLoginRequest other = (WarplyLoginRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyLoginRequest setId(String id2) {
        this.mId = id2;
        return this;
    }

    public WarplyLoginRequest setPassword(String password) {
        this.mPassword = password;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyLoginRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyLoginRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("id", (Object)(TextUtils.isEmpty((CharSequence)this.mId) ? "" : this.mId));
                bodyJsonObject.putOpt("password", (Object)(TextUtils.isEmpty((CharSequence)this.mPassword) ? "" : this.mPassword));
                bodyJsonObject.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
                bodyJsonObject.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_login_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

