/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyMerchantsRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "get_by_parent";
    private final String KEY_ACTION_VALUE_MULTILINGUAL = "retrieve_multilingual";
    private final String KEY_ACTIVE = "active";
    private final String KEY_DEFAULT_SHOWN = "default_shown";
    private final String KEY_LANGUAGE = "language";
    private final String KEY_LOCATION = "location";
    private final String KEY_CATEGORIES = "categories";
    private final String KEY_TAGS = "tags";
    private final String KEY_UUID = "uuid";
    private final String KEY_CENTER = "center";
    private final String KEY_DISTANCE = "distance";
    private final String KEY_PARENT_UUIDS = "parent_uuids";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private boolean mIsMultilingual = false;
    private ArrayList<String> mCategories = new ArrayList();
    private boolean mDefaultShown = false;
    private ArrayList<String> mTags = new ArrayList();
    private String mUuid = "";
    private int mDistance = 0;
    private ArrayList<Double> mCenter = new ArrayList();
    private String mLanguage = WarplyProperty.getLanguage(Warply.getWarplyContext());
    private ArrayList<String> mParentUuids = new ArrayList();

    public WarplyMerchantsRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyMerchantsRequest(WarplyMerchantsRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyMerchantsRequest) {
            WarplyMerchantsRequest other = (WarplyMerchantsRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyMerchantsRequest setParentUuids(ArrayList<String> uuids) {
        this.mParentUuids = uuids;
        return this;
    }

    public WarplyMerchantsRequest setIsMultilingual(boolean multilingual) {
        this.mIsMultilingual = multilingual;
        return this;
    }

    public WarplyMerchantsRequest setCategories(ArrayList<String> categories) {
        this.mCategories = categories;
        return this;
    }

    public WarplyMerchantsRequest setDefault(boolean defaultShown) {
        this.mDefaultShown = defaultShown;
        return this;
    }

    public WarplyMerchantsRequest setCenter(ArrayList<Double> center) {
        this.mCenter = center;
        return this;
    }

    public WarplyMerchantsRequest setDistance(int distance) {
        this.mDistance = distance;
        return this;
    }

    public WarplyMerchantsRequest setTags(ArrayList<String> tags) {
        this.mTags = tags;
        return this;
    }

    public WarplyMerchantsRequest setMerchantUuid(String uuid) {
        this.mUuid = uuid;
        return this;
    }

    public WarplyMerchantsRequest setLanguage(String lan) {
        this.mLanguage = lan;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyMerchantsRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyMerchantsRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block9: {
            bodyJsonObject = new JSONObject();
            try {
                if (this.mIsMultilingual) {
                    bodyJsonObject.putOpt("action", (Object)"retrieve_multilingual");
                    bodyJsonObject.putOpt("active", (Object)true);
                    bodyJsonObject.putOpt("categories", (Object)new JSONArray(this.mCategories));
                    bodyJsonObject.putOpt("default_shown", this.mDefaultShown ? Boolean.valueOf(this.mDefaultShown) : JSONObject.NULL);
                    bodyJsonObject.putOpt("language", (Object)this.mLanguage);
                    if (this.mDistance != 0 && this.mCenter != null && this.mCenter.size() > 0) {
                        JSONObject locObj = new JSONObject();
                        locObj.putOpt("center", this.mCenter);
                        locObj.putOpt("distance", (Object)this.mDistance);
                        bodyJsonObject.putOpt("location", (Object)locObj);
                        bodyJsonObject.putOpt("center", this.mCenter);
                        bodyJsonObject.putOpt("distance", (Object)this.mDistance);
                    } else {
                        bodyJsonObject.putOpt("location", JSONObject.NULL);
                    }
                    if (this.mParentUuids == null || this.mParentUuids.size() == 0) {
                        bodyJsonObject.putOpt("parent_uuids", JSONObject.NULL);
                    } else {
                        bodyJsonObject.putOpt("parent_uuids", (Object)new JSONArray(this.mParentUuids));
                    }
                    bodyJsonObject.putOpt("tags", this.mTags != null && this.mTags.size() > 0 ? new JSONArray(this.mTags) : JSONObject.NULL);
                    if (!TextUtils.isEmpty((CharSequence)this.mUuid)) {
                        bodyJsonObject.putOpt("uuid", (Object)this.mUuid);
                    }
                } else {
                    bodyJsonObject.putOpt("action", (Object)"get_by_parent");
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_shops_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

