/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyProductsRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_MERCHANT_ID = "merchant_id";
    private final String KEY_LANGUAGE = "language";
    private final String KEY_FILTERS = "filters";
    private final String KEY_CATEGORY_NAME = "category_name";
    private final String KEY_ACTION_VALUE = "get_all_multilingual";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mProductsCategory = "";
    private String mLanguage = WarplyProperty.getLanguage(Warply.getWarplyContext());

    public WarplyProductsRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyProductsRequest(WarplyProductsRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyProductsRequest) {
            WarplyProductsRequest other = (WarplyProductsRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyProductsRequest setProductFilter(String productsCategory) {
        this.mProductsCategory = productsCategory;
        return this;
    }

    public WarplyProductsRequest setLanguage(String lan) {
        this.mLanguage = lan;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyProductsRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyProductsRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"get_all_multilingual");
                bodyJsonObject.putOpt("language", (Object)this.mLanguage);
                bodyJsonObject.putOpt("merchant_id", (Object)WarplyProperty.getMerchantId(Warply.getWarplyContext()));
                JSONObject extraJson = new JSONObject();
                extraJson.put("category_name", TextUtils.isEmpty((CharSequence)this.mProductsCategory) ? JSONObject.NULL : this.mProductsCategory);
                bodyJsonObject.put("filters", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_products_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

