/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyRedeemProductRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "vcurrency_purchase";
    private final String KEY_MERCHANT_ID = "merchant_id";
    private final String KEY_PRODUCT_ID = "product_id";
    private final String KEY_PRODUCT_UUID = "product_uuid";
    private final String KEY_CAUSE = "cause";
    private final String KEY_CAUSE_VALUE = "coupon";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mId = "";
    private String mUuid = "";

    public WarplyRedeemProductRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyRedeemProductRequest(WarplyRedeemProductRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyRedeemProductRequest) {
            WarplyRedeemProductRequest other = (WarplyRedeemProductRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyRedeemProductRequest setSku(String sku) {
        this.mId = sku;
        return this;
    }

    public WarplyRedeemProductRequest setUuid(String uuid) {
        this.mUuid = uuid;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyRedeemProductRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyRedeemProductRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"vcurrency_purchase");
                bodyJsonObject.putOpt("merchant_id", (Object)WarplyProperty.getMerchantId(Warply.getWarplyContext()));
                bodyJsonObject.putOpt("product_id", (Object)this.mId);
                bodyJsonObject.putOpt("product_uuid", (Object)this.mUuid);
                bodyJsonObject.putOpt("cause", (Object)"coupon");
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_redeem_product_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

