/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyRefreshTokenRequest {
    private final String KEY_GRANT_TYPE = "grant_type";
    private final String KEY_REFRESH_TOKEN = "refresh_token";
    private final String KEY_CLIENT_ID = "client_id";
    private final String KEY_CLIENT_SECRET = "client_secret";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;

    public WarplyRefreshTokenRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyRefreshTokenRequest(WarplyRefreshTokenRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyRefreshTokenRequest) {
            WarplyRefreshTokenRequest other = (WarplyRefreshTokenRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyRefreshTokenRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyRefreshTokenRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("grant_type", (Object)"refresh_token");
                bodyJsonObject.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
                bodyJsonObject.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
                bodyJsonObject.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_refresh_token_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

