/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyRegisterRequest {
    private final String KEY_ID = "id";
    private final String KEY_PASSWORD = "password";
    private final String KEY_WEB_ID = "web_id";
    private final String KEY_FIRST_NAME = "first_name";
    private final String KEY_LAST_NAME = "last_name";
    private final String KEY_EMAIL = "email";
    private final String KEY_SALUTATION = "salutation";
    private final String KEY_MSISDN = "msisdn";
    private final String KEY_NICKNAME = "nickname";
    private final String KEY_GENDER = "gender";
    private final String KEY_BIRTHDAY = "birthday";
    private final String KEY_OPTIN = "optin";
    private final String KEY_NEWSLETTER = "newsletter";
    private final String KEY_SMS = "sms";
    private final String KEY_PERSON_NEWSLETTER = "segmentation";
    private final String KEY_PERSON_SMS = "sms_segmentation";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mId = "";
    private String mPassword = "";
    private String mFirstName = "";
    private String mLastName = "";
    private String mEmail = "";
    private String mSalutation = "";
    private String mMsisdn = "";
    private String mNickname = "";
    private String mGender = "";
    private String mBirthday = "";
    private boolean mNewsletter = false;
    private boolean mSms = false;
    private boolean mPersonalizedNewsletter = false;
    private boolean mPersonalizedSms = false;
    private boolean mAutologin = false;

    public WarplyRegisterRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyRegisterRequest(WarplyRegisterRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyRegisterRequest) {
            WarplyRegisterRequest other = (WarplyRegisterRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyRegisterRequest setId(String id2) {
        this.mId = id2;
        return this;
    }

    public WarplyRegisterRequest setPassword(String password) {
        this.mPassword = password;
        return this;
    }

    public WarplyRegisterRequest setFirstName(String firstname) {
        this.mFirstName = firstname;
        return this;
    }

    public WarplyRegisterRequest setLastName(String lastname) {
        this.mLastName = lastname;
        return this;
    }

    public WarplyRegisterRequest setEmail(String email) {
        this.mEmail = email;
        return this;
    }

    public WarplyRegisterRequest setSalutation(String salutation) {
        this.mSalutation = salutation;
        return this;
    }

    public WarplyRegisterRequest setMsisdn(String msisdn) {
        this.mMsisdn = msisdn;
        return this;
    }

    public WarplyRegisterRequest setNickname(String nickname) {
        this.mNickname = nickname;
        return this;
    }

    public WarplyRegisterRequest setGender(String gender) {
        this.mGender = gender;
        return this;
    }

    public WarplyRegisterRequest setBirthDate(String birthDate) {
        this.mBirthday = birthDate;
        return this;
    }

    public WarplyRegisterRequest setNewsletter(boolean newsletter) {
        this.mNewsletter = newsletter;
        return this;
    }

    public WarplyRegisterRequest setSms(boolean sms) {
        this.mSms = sms;
        return this;
    }

    public WarplyRegisterRequest setPersonalizedNewsletter(boolean personalizedNewsletter) {
        this.mPersonalizedNewsletter = personalizedNewsletter;
        return this;
    }

    public WarplyRegisterRequest setPersonalizedSms(boolean personalizedSms) {
        this.mPersonalizedSms = personalizedSms;
        return this;
    }

    public WarplyRegisterRequest setAutologin(boolean autologin) {
        this.mAutologin = autologin;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public boolean getAutologin() {
        return this.mAutologin;
    }

    public WarplyRegisterRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyRegisterRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("id", (Object)(TextUtils.isEmpty((CharSequence)this.mId) ? "" : this.mId));
                bodyJsonObject.putOpt("password", (Object)(TextUtils.isEmpty((CharSequence)this.mPassword) ? "" : this.mPassword));
                bodyJsonObject.putOpt("first_name", (Object)(TextUtils.isEmpty((CharSequence)this.mFirstName) ? "" : this.mFirstName));
                bodyJsonObject.putOpt("last_name", (Object)(TextUtils.isEmpty((CharSequence)this.mLastName) ? "" : this.mLastName));
                bodyJsonObject.putOpt("email", (Object)(TextUtils.isEmpty((CharSequence)this.mEmail) ? "" : this.mEmail));
                bodyJsonObject.putOpt("salutation", (Object)(TextUtils.isEmpty((CharSequence)this.mSalutation) ? "" : this.mSalutation));
                bodyJsonObject.putOpt("msisdn", (Object)(TextUtils.isEmpty((CharSequence)this.mMsisdn) ? "" : this.mMsisdn));
                bodyJsonObject.putOpt("nickname", (Object)(TextUtils.isEmpty((CharSequence)this.mNickname) ? "" : this.mNickname));
                bodyJsonObject.putOpt("gender", (Object)(TextUtils.isEmpty((CharSequence)this.mGender) ? "" : this.mGender));
                bodyJsonObject.putOpt("birthday", (Object)(TextUtils.isEmpty((CharSequence)this.mBirthday) ? "" : this.mBirthday));
                bodyJsonObject.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
                JSONObject optin = new JSONObject();
                optin.put("newsletter", this.mNewsletter);
                optin.put("sms", this.mSms);
                optin.put("segmentation", this.mPersonalizedNewsletter);
                optin.put("sms_segmentation", this.mPersonalizedSms);
                bodyJsonObject.putOpt("optin", (Object)optin);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_register_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

