/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyResetPasswordRequest {
    private final String KEY_CHANNEL = "channel";
    private final String KEY_APP_UUID = "app_uuid";
    private final String KEY_CONF_TOKEN = "conf_token";
    private final String KEY_NEW_PASS = "new_password";
    private final String KEY_CONF_CODE = "conf_code";
    private final String KEY_OTP_UUID = "otp_uuid";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mConfToken = "";
    private String mNewPassword = "";
    private String mOtp = "";
    private String mOtpUuid = "";

    public WarplyResetPasswordRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyResetPasswordRequest(WarplyResetPasswordRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyResetPasswordRequest) {
            WarplyResetPasswordRequest other = (WarplyResetPasswordRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyResetPasswordRequest setPassword(String password) {
        this.mNewPassword = password;
        return this;
    }

    public WarplyResetPasswordRequest setConfToken(String token) {
        this.mConfToken = token;
        return this;
    }

    public WarplyResetPasswordRequest setOtp(String otp) {
        this.mOtp = otp;
        return this;
    }

    public WarplyResetPasswordRequest setOtpUuid(String otpuuid) {
        this.mOtpUuid = otpuuid;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyResetPasswordRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyResetPasswordRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block4: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("channel", (Object)"mobile");
                bodyJsonObject.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
                if (!TextUtils.isEmpty((CharSequence)this.mConfToken)) {
                    bodyJsonObject.putOpt("conf_token", (Object)this.mConfToken);
                }
                bodyJsonObject.putOpt("new_password", (Object)this.mNewPassword);
                if (!TextUtils.isEmpty((CharSequence)this.mOtp)) {
                    bodyJsonObject.putOpt("conf_code", (Object)this.mOtp);
                    bodyJsonObject.putOpt("otp_uuid", (Object)this.mOtpUuid);
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_reset_password_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

