/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplySharingHistoryRequest {
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "sharing_history";
    private final String KEY_EXCLUDE = "exclude";
    private final String KEY_FIELD = "field";
    private final String KEY_VALUE = "value";
    private final String KEY_TYPE = "couponset_types";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mExcludeFilter = "";
    private String mType = "";

    public WarplySharingHistoryRequest() {
        this.mFilters = new HashMap();
    }

    public WarplySharingHistoryRequest(WarplySharingHistoryRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplySharingHistoryRequest) {
            WarplySharingHistoryRequest other = (WarplySharingHistoryRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplySharingHistoryRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplySharingHistoryRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public WarplySharingHistoryRequest setExcludeFilter(String excludeFilter) {
        this.mExcludeFilter = excludeFilter;
        return this;
    }

    public WarplySharingHistoryRequest setType(String type) {
        this.mType = type;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block6: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("action", (Object)"sharing_history");
                if (!TextUtils.isEmpty((CharSequence)this.mExcludeFilter)) {
                    JSONObject excludesKey = new JSONObject();
                    try {
                        excludesKey.putOpt("field", (Object)"couponset_type");
                        excludesKey.putOpt("value", (Object)new JSONArray().put((Object)this.mExcludeFilter));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    bodyJsonObject.put("exclude", (Object)new JSONArray().put((Object)excludesKey));
                }
                if (!TextUtils.isEmpty((CharSequence)this.mType)) {
                    bodyJsonObject.put("couponset_types", (Object)new JSONArray().put((Object)this.mType));
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_sharing_history_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

