/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyTokenAuthorizeRequest {
    private final String KEY_GRANT_TYPE = "grant_type";
    private final String KEY_CODE = "code";
    private final String KEY_CLIENT_ID = "client_id";
    private final String KEY_CLIENT_SECRET = "client_secret";
    private final String KEY_SCOPE = "scope";
    private final String KEY_REDIRECT_URI = "redirect_uri";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private JSONObject mAuthorizeData = new JSONObject();
    private boolean mIsRegister = false;

    public WarplyTokenAuthorizeRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyTokenAuthorizeRequest(WarplyTokenAuthorizeRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyTokenAuthorizeRequest) {
            WarplyTokenAuthorizeRequest other = (WarplyTokenAuthorizeRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyTokenAuthorizeRequest setAuthorizeData(JSONObject authorizeData) {
        this.mAuthorizeData = authorizeData;
        return this;
    }

    public WarplyTokenAuthorizeRequest setIsRegister(boolean isRegisterFlow) {
        this.mIsRegister = isRegisterFlow;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyTokenAuthorizeRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyTokenAuthorizeRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block4: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("grant_type", (Object)"authorization_code");
                bodyJsonObject.putOpt("code", (Object)(this.mAuthorizeData != null ? this.mAuthorizeData.optString("code") : ""));
                bodyJsonObject.putOpt("scope", (Object)(WarplyProperty.getLoginType(Warply.getWarplyContext()) + " app_id"));
                bodyJsonObject.putOpt("redirect_uri", (Object)(WarplyProperty.getBaseUrl(Warply.getWarplyContext()) + "/oauth/" + "authorized"));
                if (this.mIsRegister) {
                    JSONObject message = new JSONObject();
                    message = this.mAuthorizeData.optJSONObject("message");
                    bodyJsonObject.putOpt("client_id", (Object)(message != null ? message.optString("client_id") : ""));
                    bodyJsonObject.putOpt("client_secret", (Object)(message != null ? message.optString("client_secret") : ""));
                } else {
                    bodyJsonObject.putOpt("client_id", (Object)(this.mAuthorizeData != null ? this.mAuthorizeData.optString("client_id") : ""));
                    bodyJsonObject.putOpt("client_secret", (Object)(this.mAuthorizeData != null ? this.mAuthorizeData.optString("client_secret") : ""));
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_login_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

