/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyVerifyOTPRequest {
    private final String KEY_CHANNEL = "channel";
    private final String KEY_APP_UUID = "app_uuid";
    private final String KEY_OTP = "conf_code";
    private final String KEY_SCOPE = "scope";
    private final String KEY_OTP_UUID = "otp_uuid";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mOtp = "";
    private String mScope = "";
    private String mOtpUuid = "";

    public WarplyVerifyOTPRequest() {
        this.mFilters = new HashMap();
    }

    public WarplyVerifyOTPRequest(WarplyVerifyOTPRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WarplyVerifyOTPRequest) {
            WarplyVerifyOTPRequest other = (WarplyVerifyOTPRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public WarplyVerifyOTPRequest setOtp(String otp) {
        this.mOtp = otp;
        return this;
    }

    public WarplyVerifyOTPRequest setOtpUuid(String otpuuid) {
        this.mOtpUuid = otpuuid;
        return this;
    }

    public WarplyVerifyOTPRequest setScope(String scope) {
        this.mScope = scope;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public WarplyVerifyOTPRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public WarplyVerifyOTPRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                bodyJsonObject.putOpt("channel", (Object)"mobile");
                bodyJsonObject.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
                bodyJsonObject.putOpt("conf_code", (Object)this.mOtp);
                bodyJsonObject.putOpt("otp_uuid", (Object)this.mOtpUuid);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_verify_otp_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

