/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.volley.toolbox;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import ly.warp.sdk.io.volley.AuthFailureError;
import ly.warp.sdk.io.volley.toolbox.Authenticator;

public class AndroidAuthenticator
implements Authenticator {
    private final Context mContext;
    private final Account mAccount;
    private final String mAuthTokenType;
    private final boolean mNotifyAuthFailure;

    public AndroidAuthenticator(Context context, Account account, String authTokenType) {
        this(context, account, authTokenType, false);
    }

    private AndroidAuthenticator(Context context, Account account, String authTokenType, boolean notifyAuthFailure) {
        this.mContext = context;
        this.mAccount = account;
        this.mAuthTokenType = authTokenType;
        this.mNotifyAuthFailure = notifyAuthFailure;
    }

    public Account getAccount() {
        return this.mAccount;
    }

    @Override
    public String getAuthToken() throws AuthFailureError {
        Bundle result;
        AccountManager accountManager = AccountManager.get((Context)this.mContext);
        AccountManagerFuture future = accountManager.getAuthToken(this.mAccount, this.mAuthTokenType, this.mNotifyAuthFailure, null, null);
        try {
            result = (Bundle)future.getResult();
        }
        catch (Exception e) {
            throw new AuthFailureError("Error while retrieving auth token", e);
        }
        String authToken = null;
        if (future.isDone() && !future.isCancelled()) {
            if (result.containsKey("intent")) {
                Intent intent = (Intent)result.getParcelable("intent");
                throw new AuthFailureError(intent);
            }
            authToken = result.getString("authtoken");
        }
        if (authToken == null) {
            throw new AuthFailureError("Got null auth token for type: " + this.mAuthTokenType);
        }
        return authToken;
    }

    @Override
    public void invalidateAuthToken(String authToken) {
        AccountManager.get((Context)this.mContext).invalidateAuthToken(this.mAccount.type, authToken);
    }
}

