/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.volley.toolbox;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.volley.AuthFailureError;
import ly.warp.sdk.io.volley.Request;
import ly.warp.sdk.io.volley.toolbox.HttpStack;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientStack
implements HttpStack {
    private final int CONNECTION_TIMEOUT = 30000;
    private final int SOCKET_TIMEOUT = 30000;
    private static final String SCHEME_NAME_HTTPS = "https";
    private static final int SCHEME_PORT_HTTPS = 443;
    private static final String SCHEME_NAME_HTTP = "http";
    private static final int SCHEME_PORT_HTTP = 80;
    private static HttpClient mClient;

    public HttpClientStack() {
        if (mClient == null) {
            mClient = this.getHttpClient();
        }
    }

    @Override
    public HttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        if (mClient == null) {
            mClient = this.getHttpClient();
        }
        return mClient.execute(this.createHttpRequest(request, additionalHeaders));
    }

    private HttpUriRequest createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) throws AuthFailureError {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        Map<String, String> basicHeaders = request.getHeaders();
        if (basicHeaders != null) {
            for (Map.Entry<String, String> header : basicHeaders.entrySet()) {
                headers.add(new BasicHeader(header.getKey(), header.getValue()));
            }
        }
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> header : additionalHeaders.entrySet()) {
                headers.add(new BasicHeader(header.getKey(), header.getValue()));
            }
        }
        switch (request.getMethod()) {
            case 0: {
                HttpGet httpGet = new HttpGet(request.getUrl());
                if (headers.size() > 0) {
                    httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
                }
                return httpGet;
            }
            case 3: {
                HttpDelete httpDelete = new HttpDelete(request.getUrl());
                if (headers.size() > 0) {
                    httpDelete.setHeaders(headers.toArray(new Header[headers.size()]));
                }
                return httpDelete;
            }
            case 1: {
                HttpPost httpPost = new HttpPost(request.getUrl());
                headers.add(new BasicHeader("Content-Type", request.getBodyContentType()));
                if (request.getTag() != null && request.getTag().equals("true")) {
                    headers.add(new BasicHeader("Authorization", "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token")));
                } else if (request.getTag() != null && request.getTag().equals("cosuser")) {
                    headers.add(new BasicHeader("Authorization", "Basic MVBQNFhCQzhFYTJBaUdCNkJWZGFGUERlTTNLQ3kzMjU6YzViMzAyZDY5N2FiNGY3NzhiNThhMTg0YzBkZWRmNGU="));
                }
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
                byte[] body = request.getBody();
                if (body != null) {
                    ByteArrayEntity entity = new ByteArrayEntity(body);
                    entity.setContentType((Header)new BasicHeader("Content-Type", request.getBodyContentType()));
                    httpPost.setEntity((HttpEntity)entity);
                }
                return httpPost;
            }
            case 2: {
                HttpPut httpPut = new HttpPut(request.getUrl());
                headers.add(new BasicHeader("Content-Type", request.getBodyContentType()));
                httpPut.setHeaders(headers.toArray(new Header[headers.size()]));
                byte[] body = request.getBody();
                if (body != null) {
                    ByteArrayEntity entity = new ByteArrayEntity(body);
                    entity.setContentType((Header)new BasicHeader("Content-Type", request.getBodyContentType()));
                    httpPut.setEntity((HttpEntity)entity);
                }
                return httpPut;
            }
        }
        throw new IllegalStateException("Unknown request method.");
    }

    public HttpClient getHttpClient() {
        return new DefaultHttpClient(){

            protected ClientConnectionManager createClientConnectionManager() {
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(new Scheme(HttpClientStack.SCHEME_NAME_HTTPS, this.getHttpsSocketFactory(), 443));
                registry.register(new Scheme(HttpClientStack.SCHEME_NAME_HTTP, (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                HttpParams params = this.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
                return new ThreadSafeClientConnManager(params, registry);
            }

            protected SocketFactory getHttpsSocketFactory() {
                try {
                    TLSSocketFactory sf = new TLSSocketFactory();
                    sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    return sf;
                }
                catch (Exception e) {
                    if (WarpConstants.DEBUG) {
                        e.printStackTrace();
                    }
                    return SSLSocketFactory.getSocketFactory();
                }
            }
        };
    }

    private class TLSSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext;

        public TLSSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(null);
            this.sslContext = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{trustManager}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

