/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.volley.toolbox;

import java.io.UnsupportedEncodingException;
import ly.warp.sdk.io.volley.NetworkResponse;
import ly.warp.sdk.io.volley.ParseError;
import ly.warp.sdk.io.volley.Response;
import ly.warp.sdk.io.volley.toolbox.HttpHeaderParser;
import ly.warp.sdk.io.volley.toolbox.JsonRequest;
import org.json.JSONArray;
import org.json.JSONException;

public class JsonArrayRequest
extends JsonRequest<JSONArray> {
    public JsonArrayRequest(String url, Response.Listener<JSONArray> listener, Response.ErrorListener errorListener) {
        super(0, url, null, listener, errorListener);
    }

    @Override
    protected Response<JSONArray> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
            return Response.success(new JSONArray(jsonString), HttpHeaderParser.parseCacheHeaders(response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error(new ParseError(e));
        }
        catch (JSONException je) {
            return Response.error(new ParseError(je));
        }
    }
}

