/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.receivers;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.Nullable;
import java.util.List;
import ly.warp.sdk.Warply;
import ly.warp.sdk.services.WarplyBeaconsRangingService;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyServerPreferencesManager;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.powersave.BackgroundPowerSaver;
import org.altbeacon.beacon.startup.BootstrapNotifier;
import org.altbeacon.beacon.startup.RegionBootstrap;

public class WarplyBeaconsApplication
extends Application
implements BootstrapNotifier {
    public static final String TAG = "WarplyBeacons: ";
    private static final String[] DEFAULT_BEACON_LAYOUTS = new String[]{"m:2-3=aabb,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25", "m:0-3=0215,i:4-19,i:20-21,i:22-23,p:24-24", "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25"};
    public static final int DEFAULT_BEACON_DISTANCE_TO_SEND = 20;
    public static final long DEFAULT_BEACON_TIME_INTERVAL_TO_RESEND = 30000L;
    public static final long DEFAULT_SCAN_PERIOD = 5000L;
    private static WarplyPreferences mWarplyPref;
    private static WarplyBeaconsApplication mInstance;
    private RegionBootstrap mBootstrap;
    private Region mRegion;
    private BackgroundPowerSaver mBackgroundPowerSaver;
    private WarplyBeaconsRangingService mRangingService;
    private boolean isEnabled = false;
    private ServiceConnection mBeaconsRangingServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            WarplyBeaconsApplication.this.mRangingService = ((WarplyBeaconsRangingService.BeaconsRangingServiceBinder)service).getService();
        }

        public void onServiceDisconnected(ComponentName arg0) {
            WarplyBeaconsApplication.this.mRangingService = null;
        }
    };

    public void onCreate() {
        super.onCreate();
        mInstance = this;
        mWarplyPref = new WarplyPreferences((Context)mInstance);
        Warply.getInitializer((Context)WarplyBeaconsApplication.getInstance()).init();
        if (WarplyBeaconsApplication.getInstance() != null) {
            WarplyBeaconsApplication.getInstance().enable();
        }
        WarpUtils.log("WarplyBeacons: onCreate WarplyBeaconsApplication");
    }

    public void didEnterRegion(Region region) {
        if (this.isEnabled) {
            this.startBindRangingService();
        }
        WarpUtils.log("WarplyBeacons: didEnterRegion");
    }

    public void didExitRegion(Region region) {
        if (this.isEnabled) {
            this.stopUnBindRangingService();
        }
        WarpUtils.log("WarplyBeacons: didExitRegion");
    }

    public void didDetermineStateForRegion(int i, Region region) {
        WarpUtils.log("WarplyBeacons: didDetermineStateForRegion");
    }

    private void initBeaconLayouts(String[] layouts) {
        block4: {
            BeaconManager beaconManager;
            block5: {
                if (layouts == null || layouts.length <= 0) break block4;
                beaconManager = BeaconManager.getInstanceForApplication((Context)WarplyBeaconsApplication.getInstance());
                if (!beaconManager.isAnyConsumerBound()) break block5;
                if (this.mBootstrap == null || WarplyBeaconsApplication.getInstance() == null) break block4;
                this.mBootstrap.disable();
                if (this.mRangingService != null) {
                    this.mRangingService.stopBeaconListener();
                }
                if (!beaconManager.isAnyConsumerBound()) {
                    List parsers = beaconManager.getBeaconParsers();
                    for (String layout2 : layouts) {
                        parsers.add(new BeaconParser().setBeaconLayout(layout2));
                    }
                }
                this.mBootstrap = new RegionBootstrap((BootstrapNotifier)WarplyBeaconsApplication.getInstance(), this.mRegion);
                if (this.mRangingService == null) break block4;
                this.mRangingService.startBeaconListener();
                break block4;
            }
            List parsers = beaconManager.getBeaconParsers();
            for (String layout3 : layouts) {
                parsers.add(new BeaconParser().setBeaconLayout(layout3));
            }
        }
    }

    private boolean checkAvailability() {
        try {
            return BeaconManager.getInstanceForApplication((Context)this).checkAvailability();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private void startBindRangingService() {
        this.startService(new Intent((Context)this, WarplyBeaconsRangingService.class));
        this.bindService(new Intent((Context)this, WarplyBeaconsRangingService.class), this.mBeaconsRangingServiceConnection, 1);
    }

    private void stopUnBindRangingService() {
        if (this.mRangingService != null) {
            this.unbindService(this.mBeaconsRangingServiceConnection);
        }
        this.stopService(new Intent((Context)this, WarplyBeaconsRangingService.class));
    }

    @Nullable
    public static synchronized WarplyBeaconsApplication getInstance() {
        return mInstance;
    }

    public void enable() {
        if (this.checkAvailability() && !this.isEnabled && WarplyBeaconsApplication.isMicroAppEnabled() && WarplyBeaconsApplication.getInstance() != null) {
            this.initBeaconLayouts(WarplyBeaconsApplication.getBeaconLayouts());
            this.mRegion = new Region("BootStrapRegion", null, null, null);
            this.mBootstrap = new RegionBootstrap((BootstrapNotifier)WarplyBeaconsApplication.getInstance(), this.mRegion);
            this.mBackgroundPowerSaver = new BackgroundPowerSaver((Context)WarplyBeaconsApplication.getInstance());
            this.isEnabled = !this.isEnabled;
            WarpUtils.log("WarplyBeacons: setting up beacons monitoring");
        }
    }

    public void disable() {
        if (this.isEnabled) {
            if (this.mBootstrap != null) {
                this.mBootstrap.disable();
            }
            this.stopUnBindRangingService();
            this.isEnabled = !this.isEnabled;
        }
    }

    public void addBeaconLayouts(String[] layouts) {
        if (this.isEnabled) {
            this.initBeaconLayouts(layouts);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static boolean isMicroAppEnabled() {
        return Warply.isInitialized() && WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.BEACONS);
    }

    public static String[] getBeaconLayouts() {
        return mWarplyPref == null ? DEFAULT_BEACON_LAYOUTS : mWarplyPref.getStringArray("BEACON_LAYOUTS", DEFAULT_BEACON_LAYOUTS);
    }

    public static int getBeaconDistanceToSendWarply() {
        return mWarplyPref == null ? 20 : mWarplyPref.getInt("BEACON_MAX_DISTANCE", 20);
    }

    public static long getBeaconTimeIntervalToSendWarply() {
        return mWarplyPref == null ? 30000L : mWarplyPref.getLong("BEACON_TIME_INTERVAL_TO_RESEND", 30000L);
    }

    public static long getBeaconScanPeriod() {
        return mWarplyPref == null ? 5000L : mWarplyPref.getLong("BEACON_TIME_INTERVAL", 5000L);
    }

    static {
        mInstance = null;
    }
}

