/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import java.util.ArrayList;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.LoyaltyEventModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;

public class EventCampaignCouponService
extends Worker {
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
            Thread.currentThread().interrupt();
        }
    };
    private CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>(){

        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            LoyaltyEventModel campaignsAdded = new LoyaltyEventModel();
            EventBus.getDefault().post((Object)new WarplyEventBusManager(campaignsAdded));
        }

        @Override
        public void onFailure(int errorCode) {
            Thread.currentThread().interrupt();
        }
    };

    public EventCampaignCouponService(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        WarplyManager.getUserCouponsWithCouponsets(this.mUserCouponsReceiver);
        WarplyManager.getCampaigns(this.mCampaignsCallback);
        return ListenableWorker.Result.success();
    }
}

