/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.Warply;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.PushCampaign;
import ly.warp.sdk.services.PushEventsWorkerService;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import org.json.JSONException;
import org.json.JSONObject;

public class HMSBaseMessagingService
extends HmsMessageService {
    private static final String KEY_TITLE = "alert";
    private static final String KEY_SUBTITLE = "subtitle";
    private static final String KEY_TICKER = "alert";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_PAYLOAD = "payload";
    private String mSenderId;
    private static Bitmap bFinal = null;

    public HMSBaseMessagingService() {
    }

    public HMSBaseMessagingService(String senderId) {
        this.mSenderId = senderId;
    }

    public void onNewToken(String s, Bundle bundle) {
        super.onNewToken(s, bundle);
        WarpUtils.setDeviceToken((Context)this, s);
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        JSONObject data = new JSONObject(remoteMessage.getDataOfMap());
        if (data == null || !data.has("loyalty-action")) {
            return;
        }
        PushCampaign pc = new PushCampaign(data);
        WarpUtils.log("Received push with action: " + pc.getAction());
        if (pc.getAction() == 0 && !pc.hasActions()) {
            HMSBaseMessagingService.showCampaignNotification((Context)this, pc);
        } else {
            Bundle bundledData = null;
            try {
                bundledData = HMSBaseMessagingService.jsonToBundle(data);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.showDefaultNotification((Context)this, bundledData);
        }
    }

    public void onSendError(String s, Exception e) {
        super.onSendError(s, e);
    }

    private void setUpPushEvents(PushCampaign pc) {
        Warply.getInitializer((Context)this).init();
        WarplyAnalyticsManager.logUserReceivedPush(pc);
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest sendEvent = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PushEventsWorkerService.class).setConstraints(constraints)).setInitialDelay((long)this.defineRandomStart(), TimeUnit.MINUTES)).build();
        WorkManager.getInstance((Context)this).enqueue((WorkRequest)sendEvent);
    }

    private int defineRandomStart() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThreadLocalRandom.current().nextInt(20, 61);
        }
        SecureRandom rand = new SecureRandom();
        return rand.nextInt(41) + 20;
    }

    public static void showCampaignNotification(Context context, PushCampaign pc) {
        HMSBaseMessagingService.showCampaignNotification(context, pc, null);
    }

    public static void showCampaignNotification(Context context, PushCampaign pc, List<NotificationCompat.Action> actions) {
        HMSBaseMessagingService.showCampaignNotification(context, pc, null, null);
    }

    public static void showCampaignNotification(Context context, PushCampaign pc, List<NotificationCompat.Action> actions, RemoteViews remoteViews) {
        WarpUtils.log("Showing campaign with session UUID: " + pc.getSessionUUID());
        SecureRandom randomGenerator = new SecureRandom();
        int uid = randomGenerator.nextInt(1000);
        if (!TextUtils.isEmpty((CharSequence)pc.getSessionUUID())) {
            uid = 0;
        }
        Intent newIntent = WarpViewActivity.createIntentFromSessionUUID(context, pc.getSessionUUID(), "from_notification_status");
        newIntent.setAction(Long.toString(System.currentTimeMillis()));
        NotificationCompat.Builder b = new NotificationCompat.Builder(context, "warply_channel");
        if (pc.getNotificationStyle().equalsIgnoreCase("big_picture") && !TextUtils.isEmpty((CharSequence)pc.getBigPictureUrl())) {
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.bigPicture(HMSBaseMessagingService.loadDrawable(pc.getBigPictureUrl()));
            if (!TextUtils.isEmpty((CharSequence)pc.getSubtitle())) {
                bigPictureStyle.setSummaryText((CharSequence)pc.getSubtitle());
            }
            b.setStyle((NotificationCompat.Style)bigPictureStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("big_text") && !TextUtils.isEmpty((CharSequence)pc.getBigText())) {
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.bigText((CharSequence)pc.getBigText());
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                bigTextStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)bigTextStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("inbox_style")) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (int i = 0; i < pc.getInboxLines().size(); ++i) {
                inboxStyle.addLine((CharSequence)pc.getInboxLines().get(i));
            }
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                inboxStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)inboxStyle);
        }
        b.setDefaults(6);
        b.setTicker((CharSequence)pc.getTicker());
        b.setChannelId("warply_channel");
        b.setContentTitle((CharSequence)pc.getTitle());
        b.setContentText((CharSequence)pc.getSubtitle());
        b.setSubText((CharSequence)pc.getContent());
        if (Build.VERSION.SDK_INT >= 31) {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x42000000));
        } else {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x40000000));
        }
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setAutoCancel(true);
        b.setSmallIcon(WarplyProperty.getPushIconResId(context));
        b.setLargeIcon(HMSBaseMessagingService.loadDrawable(pc.getImageUrl()));
        if (remoteViews != null) {
            b.setContent(remoteViews);
        }
        if (pc.getSoundUri(context) == null) {
            b.setSound(RingtoneManager.getDefaultUri((int)2));
        } else {
            b.setSound(pc.getSoundUri(context));
        }
        int color2 = WarplyProperty.getPushColor(context);
        if (!TextUtils.isEmpty((CharSequence)pc.getColor())) {
            try {
                color2 = Color.parseColor((String)pc.getColor());
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
        }
        b.setColor(color2);
        if (actions != null && actions.size() > 0) {
            for (NotificationCompat.Action action : actions) {
                b.addAction(action);
            }
        }
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && nm != null) {
            NotificationChannel notificationChannel = new NotificationChannel("warply_channel", (CharSequence)"notification_channel", 3);
            nm.createNotificationChannel(notificationChannel);
            Notification notification_build_with_largeicon = b.setChannelId("warply_channel").build();
            notification_build_with_largeicon.flags = 16;
            nm.notify(pc.getSessionUUID(), uid, notification_build_with_largeicon);
        } else {
            Notification notification_build_with_largeicon = b.build();
            notification_build_with_largeicon.flags = 16;
            nm.notify(pc.getSessionUUID(), uid, notification_build_with_largeicon);
        }
    }

    public void showDefaultNotification(Context context, Bundle data) {
        String title = this.getNotificationTitle(data);
        String ticker = this.getNotificationTicker(data);
        String message = this.getNotificationMessage(data);
        PushCampaign pc = new PushCampaign(data);
        if (pc != null) {
            PackageManager pm = context.getPackageManager();
            Intent newIntent = pm.getLaunchIntentForPackage(context.getPackageName());
            this.showNotification(context, pc, newIntent, null, null, null, 0);
        }
    }

    public void showNotification(Context context, PushCampaign pc, Intent newIntent, List<NotificationCompat.Action> actions, RemoteViews remoteViews, String tag, int id2) {
        SecureRandom randomGenerator = new SecureRandom();
        int uid = randomGenerator.nextInt(1000);
        if (id2 > 0) {
            uid = id2;
        }
        WarpUtils.log("Showing notification with tag: " + tag + " and id: " + id2);
        NotificationCompat.Builder b = new NotificationCompat.Builder(context, "warply_channel");
        if (pc.getNotificationStyle().equalsIgnoreCase("big_picture") && !TextUtils.isEmpty((CharSequence)pc.getBigPictureUrl())) {
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.bigPicture(HMSBaseMessagingService.loadDrawable(pc.getBigPictureUrl()));
            if (!TextUtils.isEmpty((CharSequence)pc.getSubtitle())) {
                bigPictureStyle.setSummaryText((CharSequence)pc.getSubtitle());
            }
            b.setStyle((NotificationCompat.Style)bigPictureStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("big_text") && !TextUtils.isEmpty((CharSequence)pc.getBigText())) {
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.bigText((CharSequence)pc.getBigText());
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                bigTextStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)bigTextStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("inbox_style")) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (int i = 0; i < pc.getInboxLines().size(); ++i) {
                inboxStyle.addLine((CharSequence)pc.getInboxLines().get(i));
            }
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                inboxStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)inboxStyle);
        }
        b.setDefaults(6);
        b.setTicker((CharSequence)pc.getTicker());
        b.setChannelId("warply_channel");
        b.setContentTitle((CharSequence)pc.getTitle());
        b.setContentText((CharSequence)pc.getSubtitle());
        b.setSubText((CharSequence)pc.getContent());
        if (Build.VERSION.SDK_INT >= 31) {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x42000000));
        } else {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x40000000));
        }
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setAutoCancel(true);
        b.setSmallIcon(WarplyProperty.getPushIconResId(context));
        b.setLargeIcon(HMSBaseMessagingService.loadDrawable(pc.getImageUrl()));
        if (remoteViews != null) {
            b.setContent(remoteViews);
        }
        if (pc.getSoundUri(context) == null) {
            b.setSound(RingtoneManager.getDefaultUri((int)2));
        } else {
            b.setSound(pc.getSoundUri(context));
        }
        int color2 = WarplyProperty.getPushColor(context);
        if (!TextUtils.isEmpty((CharSequence)pc.getColor())) {
            try {
                color2 = Color.parseColor((String)pc.getColor());
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
        }
        b.setColor(color2);
        if (actions != null && actions.size() > 0) {
            for (NotificationCompat.Action action : actions) {
                b.addAction(action);
            }
        }
        newIntent.setAction(Long.toString(System.currentTimeMillis()));
        PendingIntent pi = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x42000000) : PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x40000000);
        b.setContentIntent(pi);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && nm != null) {
            NotificationChannel notificationChannel = new NotificationChannel("warply_channel", (CharSequence)"notification_channel", 3);
            nm.createNotificationChannel(notificationChannel);
            Notification notification_build = b.setChannelId("warply_channel").build();
            notification_build.flags = 16;
            nm.notify(pc.getSessionUUID(), uid, notification_build);
        } else {
            Notification notification_build = b.build();
            notification_build.flags = 16;
            nm.notify(pc.getSessionUUID(), uid, notification_build);
        }
    }

    public JSONObject getPayload(Bundle data) {
        String payloadStr = data.getString(KEY_PAYLOAD);
        try {
            JSONObject payload = new JSONObject(payloadStr);
            return payload;
        }
        catch (JSONException e) {
            WarpUtils.log("Error with payload", (Exception)((Object)e));
            return null;
        }
    }

    public String getNotificationTitle(Bundle data) {
        return data.getString("alert");
    }

    public String getNotificationMessage(Bundle data) {
        return data.getString(KEY_MESSAGE);
    }

    public String getNotificationTicker(Bundle data) {
        return data.getString("alert");
    }

    public String getNotificationSubtitle(Bundle data) {
        return data.getString(KEY_SUBTITLE);
    }

    private static Bitmap loadDrawable(String urlString) {
        if (urlString == null || TextUtils.isEmpty((CharSequence)urlString)) {
            return null;
        }
        URLThread urlThread = new URLThread(urlString);
        try {
            urlThread.start();
            urlThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bFinal;
    }

    private void getSmallIcon(Context context, PushCampaign pc) {
    }

    public static Bundle jsonToBundle(JSONObject jsonObject) throws JSONException {
        Bundle bundle = new Bundle();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = jsonObject.getString(key);
            bundle.putString(key, value);
        }
        return bundle;
    }

    public static class URLThread
    extends Thread {
        private String urlString = "";

        public URLThread(String url) {
            this.urlString = url;
        }

        @Override
        public void run() {
            try {
                HttpURLConnection urlConnection = null;
                URL url = new URL(this.urlString);
                urlConnection = (HttpURLConnection)url.openConnection();
                if (urlConnection.getResponseCode() != 200) {
                    bFinal = null;
                    return;
                }
                InputStream is = urlConnection.getInputStream();
                if (is == null) {
                    urlConnection.disconnect();
                    bFinal = null;
                    return;
                }
                Bitmap b = BitmapFactory.decodeStream((InputStream)is);
                is.close();
                urlConnection.disconnect();
                bFinal = b;
            }
            catch (Exception ex) {
                bFinal = null;
                ex.printStackTrace();
            }
        }
    }
}

