/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.Warply;
import ly.warp.sdk.dexter.listener.DexterError;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.WarpGeoFence;
import ly.warp.sdk.receivers.LocationChangedReceiver;
import ly.warp.sdk.utils.PermissionsUtil;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyLocationManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateUserLocationService
extends Worker {
    public static final String TAG = "LOCATION_KEY";
    private int lastForProvider;
    private float lastForTime;
    private double lastForDistance;
    private int lastBacProvider;
    private float lastBacTime;
    private double lastBacDistance;
    private boolean geofencingEnabled = false;
    private List<WarpGeoFence> geofences = null;
    private static int defaultCheckInterval = 15;
    private static final int defaultInterval = 15;
    private final PermissionsUtil.PermissionCallback mPermissionsCallback = new PermissionsUtil.PermissionCallback(){

        @Override
        public void onError(DexterError error) {
            this.onPermissionDenied(null);
        }

        @Override
        public void onPermissionDenied(List<PermissionDeniedResponse> denied) {
            if (denied != null && denied.size() < 2) {
                this.onPermissionsGranted();
            }
        }

        @Override
        public void onPermissionsGranted() {
            try {
                FusedLocationProviderClient locationClient = LocationServices.getFusedLocationProviderClient((Context)Warply.getWarplyContext());
                locationClient.getCurrentLocation(100, new CancellationToken(){

                    @NonNull
                    public CancellationToken onCanceledRequested(@NonNull OnTokenCanceledListener onTokenCanceledListener) {
                        return null;
                    }

                    public boolean isCancellationRequested() {
                        return false;
                    }
                }).addOnSuccessListener(location1 -> {
                    if (location1 != null) {
                        UpdateUserLocationService.this.sendLocation(location1);
                    }
                }).addOnFailureListener(e -> WarpUtils.log("Could not get location data."));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    };

    public UpdateUserLocationService(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        if (Warply.getWarplyContext() != null) {
            if (new WarplyPreferences(Warply.getWarplyContext()).getAppStatus().equals("foreground")) {
                try {
                    new PermissionsUtil(Warply.getWarplyContext(), this.mPermissionsCallback, "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION").requestPermissions();
                }
                catch (SecurityException securityException) {}
            } else {
                WorkManager.getInstance((Context)Warply.getWarplyContext()).cancelAllWorkByTag(TAG);
            }
        } else {
            WorkManager.getInstance((Context)this.getApplicationContext()).cancelAllWorkByTag(TAG);
        }
        this.regulateLocationReporting();
        return ListenableWorker.Result.success();
    }

    private void sendLocationData(double lat, double lon) {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt("action", (Object)"tracking");
            jObj.putOpt("lat", (Object)lat);
            jObj.putOpt("lon", (Object)lon);
        }
        catch (JSONException e) {
            WarpUtils.log("JSON Exception thrown while creating the object in sendLocationData at WarplyLocationManager", (Exception)((Object)e));
        }
        if (LocationChangedReceiver.wClient != null) {
            Warply.postReceiveMicroappData("geofencing", jObj, new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    WarpUtils.log("success sending location " + result.toString());
                }

                @Override
                public void onFailure(int errorCode) {
                    WarpUtils.log("failed during sending location data with error " + errorCode);
                }
            });
        } else {
            WarpUtils.log("Could not send user location data. You must registrer to warply first");
        }
    }

    private void sendLocation(Location location) {
        if (this.isGeofencingEnabled()) {
            if (this.isInsideFence(location.getLatitude(), location.getLongitude())) {
                this.sendLocationData(location.getLatitude(), location.getLongitude());
            }
        } else {
            this.sendLocationData(location.getLatitude(), location.getLongitude());
        }
        if (this.isGeofencingEnabled() && (this.getGeofences() == null || this.getGeofences().isEmpty())) {
            this.retrieveGeofences();
        }
    }

    private void retrieveGeofences() {
        if (!this.isGeofencingEnabled()) {
            return;
        }
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt("action", (Object)"get_pois");
        }
        catch (JSONException e) {
            WarpUtils.log("JSON Exception thrown while creating the object in retrieveGeofences at WarplyLocationManager", (Exception)((Object)e));
            return;
        }
        if (LocationChangedReceiver.wClient != null) {
            Warply.postReceiveMicroappData("geofencing", jObj, new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    JSONObject json = result.optJSONObject("context");
                    if (json != null) {
                        try {
                            JSONArray geoArray = json.getJSONArray("MAPP_GEOFENCING");
                            UpdateUserLocationService.this.geofences = new ArrayList();
                            for (int i = 0; i < geoArray.length(); ++i) {
                                UpdateUserLocationService.this.getGeofences().add(new WarpGeoFence(geoArray.getJSONObject(i)));
                            }
                        }
                        catch (JSONException e) {
                            UpdateUserLocationService.this.geofences = null;
                            WarpUtils.log("failed during parsing geofencing data.");
                        }
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    UpdateUserLocationService.this.geofences = null;
                    WarpUtils.log("failed during getting geofencing data with error " + errorCode);
                }
            });
        } else {
            WarpUtils.log("Could not get geofencing data. You must registrer to warply first");
        }
    }

    public boolean isInsideFence(double lat, double lon) {
        if (this.getGeofences() == null) {
            return false;
        }
        for (WarpGeoFence fence : this.getGeofences()) {
            if (!fence.isInsideFence(lat, lon)) continue;
            return true;
        }
        return false;
    }

    private void regulateLocationReporting() {
        Warply.getContext(new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                JSONObject appDataJson;
                JSONObject json = result.optJSONObject("context");
                if (json != null && (appDataJson = json.optJSONObject("application_data")) != null) {
                    int foregroundProvider = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.LOCATION_FOREGROUND_MODE.getJsonKey(), 0);
                    long foregroundMinTime = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.FOREGROUND_MIN_TIME.getJsonKey(), 60000);
                    float foregroundMinDistance = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.FOREGROUND_MIN_DISTANCE.getJsonKey(), 100);
                    int backgroundProvider = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.LOCATION_BACKGROUND_MODE.getJsonKey(), 0);
                    long backgroundMinTime = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.BACKGROUND_MIN_TIME.getJsonKey(), 60000);
                    float backgroundMinDistance = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.BACKGROUND_MIN_DISTANCE.getJsonKey(), 100);
                    int interval = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.FEATURES_CHECK_INTERVAL.getJsonKey(), 86400);
                    UpdateUserLocationService.this.geofencingEnabled = WarpJSONParser.getBooleanFromJSONObject(appDataJson, WarpConstants.LocationSetting.GEOFENCING_POIS_ENABLED.getJsonKey(), false);
                    Log.i((String)"notification interval", (String)Integer.toString(interval));
                    if (interval != defaultCheckInterval) {
                        defaultCheckInterval = interval;
                    }
                    Context context = Warply.getWarplyContext();
                    String appStatus = new WarplyPreferences(context).getAppStatus();
                    if (foregroundProvider == WarpConstants.LocationModes.OFF.ordinal() && backgroundProvider == WarpConstants.LocationModes.OFF.ordinal()) {
                        WarplyLocationManager.stopReportingLocation(context);
                    } else if (foregroundProvider == WarpConstants.LocationModes.OFF.ordinal()) {
                        if (!LocationChangedReceiver.isAppShutDown && appStatus.equals("foreground")) {
                            WarplyLocationManager.stopReportingLocation(context);
                        } else if (UpdateUserLocationService.this.lastBacProvider != backgroundProvider || UpdateUserLocationService.this.lastBacTime != (float)backgroundMinTime || UpdateUserLocationService.this.lastBacDistance != (double)backgroundMinDistance) {
                            if (WarplyLocationManager.getLocationManager() == null) {
                                WarplyLocationManager.instantiateLocationManager();
                            }
                            WarplyLocationManager.startReportingLocation(context, WarpConstants.LocationModes.values()[backgroundProvider].getJsonKey(), backgroundMinTime * 1000L, backgroundMinDistance);
                            UpdateUserLocationService.this.lastBacProvider = backgroundProvider;
                            UpdateUserLocationService.this.lastBacTime = backgroundMinTime;
                            UpdateUserLocationService.this.lastBacDistance = backgroundMinDistance;
                        }
                    } else if (backgroundProvider == WarpConstants.LocationModes.OFF.ordinal()) {
                        if (LocationChangedReceiver.isAppShutDown || appStatus.equals("background")) {
                            WarplyLocationManager.stopReportingLocation(context);
                        } else if (UpdateUserLocationService.this.lastForProvider != foregroundProvider || UpdateUserLocationService.this.lastForTime != (float)foregroundMinTime || UpdateUserLocationService.this.lastForDistance != (double)foregroundMinDistance) {
                            WarplyLocationManager.startReportingLocation(context, WarpConstants.LocationModes.values()[foregroundProvider].getJsonKey(), foregroundMinTime * 1000L, foregroundMinDistance);
                            UpdateUserLocationService.this.lastForProvider = foregroundProvider;
                            UpdateUserLocationService.this.lastForTime = foregroundMinTime;
                            UpdateUserLocationService.this.lastForDistance = foregroundMinDistance;
                        }
                    } else if (!LocationChangedReceiver.isAppShutDown && appStatus.equals("foreground")) {
                        if (UpdateUserLocationService.this.lastForProvider != foregroundProvider || UpdateUserLocationService.this.lastForTime != (float)foregroundMinTime || UpdateUserLocationService.this.lastForDistance != (double)foregroundMinDistance) {
                            WarplyLocationManager.startReportingLocation(context, WarpConstants.LocationModes.values()[foregroundProvider].getJsonKey(), foregroundMinTime * 1000L, foregroundMinDistance);
                            UpdateUserLocationService.this.lastForProvider = foregroundProvider;
                            UpdateUserLocationService.this.lastForTime = foregroundMinTime;
                            UpdateUserLocationService.this.lastForDistance = foregroundMinDistance;
                        }
                    } else if (UpdateUserLocationService.this.lastBacProvider != backgroundProvider || UpdateUserLocationService.this.lastBacTime != (float)backgroundMinTime || UpdateUserLocationService.this.lastBacDistance != (double)backgroundMinDistance) {
                        if (WarplyLocationManager.getLocationManager() == null) {
                            WarplyLocationManager.instantiateLocationManager();
                        }
                        WarplyLocationManager.startReportingLocation(context, WarpConstants.LocationModes.values()[backgroundProvider].getJsonKey(), backgroundMinTime * 1000L, backgroundMinDistance);
                        UpdateUserLocationService.this.lastBacProvider = backgroundProvider;
                        UpdateUserLocationService.this.lastBacTime = backgroundMinTime;
                        UpdateUserLocationService.this.lastBacDistance = backgroundMinDistance;
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                WarpUtils.log("Error with code " + errorCode + " while checking location modes");
            }
        });
    }

    public synchronized List<WarpGeoFence> getGeofences() {
        return this.geofences;
    }

    public synchronized boolean isGeofencingEnabled() {
        return this.geofencingEnabled;
    }

    private static PeriodicWorkRequest buildWorkRequest(Map<String, Object> location) {
        Data inputData = new Data.Builder().putAll(location).build();
        return (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(UpdateUserLocationService.class, 15L, TimeUnit.MINUTES).addTag(TAG)).setInputData(inputData)).build();
    }

    public static void scheduleWork(Context context, Map<String, Object> location) {
        WorkManager.getInstance((Context)context).enqueueUniquePeriodicWork(TAG, ExistingPeriodicWorkPolicy.KEEP, UpdateUserLocationService.buildWorkRequest(location));
    }
}

