/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.List;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.PushCampaign;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class WarpBaseIntentService
extends IntentService {
    private static final String KEY_TITLE = "alert";
    private static final String KEY_SUBTITLE = "subtitle";
    private static final String KEY_TICKER = "alert";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_PAYLOAD = "payload";

    public WarpBaseIntentService() {
        super("WarpBaseIntentService");
    }

    public static void showCampaignNotification(Context context, PushCampaign pc) {
        WarpBaseIntentService.showCampaignNotification(context, pc, null);
    }

    public static void showCampaignNotification(Context context, PushCampaign pc, List<NotificationCompat.Action> actions) {
        WarpBaseIntentService.showCampaignNotification(context, pc, null, null);
    }

    public static void showCampaignNotification(Context context, PushCampaign pc, List<NotificationCompat.Action> actions, RemoteViews remoteViews) {
        WarpUtils.log("Showing campaign with session UUID: " + pc.getSessionUUID());
        SecureRandom randomGenerator = new SecureRandom();
        int uid = randomGenerator.nextInt(1000);
        if (!TextUtils.isEmpty((CharSequence)pc.getSessionUUID())) {
            uid = 0;
        }
        Intent newIntent = WarpViewActivity.createIntentFromSessionUUID(context, pc.getSessionUUID(), "from_notification_status");
        newIntent.setAction(Long.toString(System.currentTimeMillis()));
        NotificationCompat.Builder b = new NotificationCompat.Builder(context, "warply_channel");
        if (pc.getNotificationStyle().equalsIgnoreCase("big_picture") && !TextUtils.isEmpty((CharSequence)pc.getBigPictureUrl())) {
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.bigPicture(WarpBaseIntentService.loadDrawable(pc.getBigPictureUrl()));
            if (!TextUtils.isEmpty((CharSequence)pc.getSubtitle())) {
                bigPictureStyle.setSummaryText((CharSequence)pc.getSubtitle());
            }
            b.setStyle((NotificationCompat.Style)bigPictureStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("big_text") && !TextUtils.isEmpty((CharSequence)pc.getBigText())) {
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.bigText((CharSequence)pc.getBigText());
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                bigTextStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)bigTextStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("inbox_style")) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (int i = 0; i < pc.getInboxLines().size(); ++i) {
                inboxStyle.addLine((CharSequence)pc.getInboxLines().get(i));
            }
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                inboxStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)inboxStyle);
        }
        b.setDefaults(6);
        b.setTicker((CharSequence)pc.getTicker());
        b.setContentTitle((CharSequence)pc.getTitle());
        b.setContentText((CharSequence)pc.getSubtitle());
        b.setSubText((CharSequence)pc.getContent());
        if (Build.VERSION.SDK_INT >= 31) {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x42000000));
        } else {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x40000000));
        }
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setAutoCancel(true);
        b.setSmallIcon(WarplyProperty.getPushIconResId(context));
        b.setLargeIcon(WarpBaseIntentService.loadDrawable(pc.getImageUrl()));
        if (remoteViews != null) {
            b.setContent(remoteViews);
        }
        if (pc.getSoundUri(context) == null) {
            b.setSound(RingtoneManager.getDefaultUri((int)2));
        } else {
            b.setSound(pc.getSoundUri(context));
        }
        int color2 = WarplyProperty.getPushColor(context);
        if (!TextUtils.isEmpty((CharSequence)pc.getColor())) {
            try {
                color2 = Color.parseColor((String)pc.getColor());
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
        }
        b.setColor(color2);
        if (actions != null && actions.size() > 0) {
            for (NotificationCompat.Action action : actions) {
                b.addAction(action);
            }
        }
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && nm != null) {
            NotificationChannel notificationChannel = new NotificationChannel("warply_channel", (CharSequence)"notification_channel", 3);
            nm.createNotificationChannel(notificationChannel);
            b.build().flags = 16;
            nm.notify(pc.getSessionUUID(), uid, b.build());
        } else {
            Notification notification_build_with_largeicon = b.build();
            b.build().flags = 16;
            nm.notify(pc.getSessionUUID(), uid, b.build());
        }
    }

    public void showDefaultNotification(Context context, Bundle data) {
        String title = this.getNotificationTitle(data);
        String ticker = this.getNotificationTicker(data);
        String message = this.getNotificationMessage(data);
        PushCampaign pc = new PushCampaign(data);
        if (pc != null) {
            PackageManager pm = context.getPackageManager();
            Intent newIntent = pm.getLaunchIntentForPackage(context.getPackageName());
            this.showNotification(context, pc, newIntent, null, null, null, 0);
        }
    }

    public void showNotification(Context context, PushCampaign pc, Intent newIntent, List<NotificationCompat.Action> actions, RemoteViews remoteViews, String tag, int id2) {
        SecureRandom randomGenerator = new SecureRandom();
        int uid = randomGenerator.nextInt(1000);
        if (id2 > 0) {
            uid = id2;
        }
        WarpUtils.log("Showing notification with tag: " + tag + " and id: " + id2);
        NotificationCompat.Builder b = new NotificationCompat.Builder(context, "warply_channel");
        if (pc.getNotificationStyle().equalsIgnoreCase("big_picture") && !TextUtils.isEmpty((CharSequence)pc.getBigPictureUrl())) {
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.bigPicture(WarpBaseIntentService.loadDrawable(pc.getBigPictureUrl()));
            if (!TextUtils.isEmpty((CharSequence)pc.getSubtitle())) {
                bigPictureStyle.setSummaryText((CharSequence)pc.getSubtitle());
            }
            b.setStyle((NotificationCompat.Style)bigPictureStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("big_text") && !TextUtils.isEmpty((CharSequence)pc.getBigText())) {
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.bigText((CharSequence)pc.getBigText());
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                bigTextStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)bigTextStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase("inbox_style")) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (int i = 0; i < pc.getInboxLines().size(); ++i) {
                inboxStyle.addLine((CharSequence)pc.getInboxLines().get(i));
            }
            if (!TextUtils.isEmpty((CharSequence)pc.getSummaryText())) {
                inboxStyle.setSummaryText((CharSequence)pc.getSummaryText());
            }
            b.setStyle((NotificationCompat.Style)inboxStyle);
        }
        b.setDefaults(6);
        b.setTicker((CharSequence)pc.getTicker());
        b.setContentTitle((CharSequence)pc.getTitle());
        b.setContentText((CharSequence)pc.getSubtitle());
        b.setSubText((CharSequence)pc.getContent());
        if (Build.VERSION.SDK_INT >= 31) {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x42000000));
        } else {
            b.setContentIntent(PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x40000000));
        }
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setAutoCancel(true);
        b.setSmallIcon(WarplyProperty.getPushIconResId(context));
        b.setLargeIcon(WarpBaseIntentService.loadDrawable(pc.getImageUrl()));
        if (remoteViews != null) {
            b.setContent(remoteViews);
        }
        if (pc.getSoundUri(context) == null) {
            b.setSound(RingtoneManager.getDefaultUri((int)2));
        } else {
            b.setSound(pc.getSoundUri(context));
        }
        int color2 = WarplyProperty.getPushColor(context);
        if (!TextUtils.isEmpty((CharSequence)pc.getColor())) {
            try {
                color2 = Color.parseColor((String)pc.getColor());
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
        }
        b.setColor(color2);
        if (actions != null && actions.size() > 0) {
            for (NotificationCompat.Action action : actions) {
                b.addAction(action);
            }
        }
        newIntent.setAction(Long.toString(System.currentTimeMillis()));
        PendingIntent pi = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x42000000) : PendingIntent.getActivity((Context)context, (int)uid, (Intent)newIntent, (int)0x40000000);
        b.setContentIntent(pi);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && nm != null) {
            NotificationChannel notificationChannel = new NotificationChannel("warply_channel", (CharSequence)"notification_channel", 3);
            nm.createNotificationChannel(notificationChannel);
            b.build().flags = 16;
            nm.notify(pc.getSessionUUID(), uid, b.build());
        } else {
            b.build().flags = 16;
            nm.notify(pc.getSessionUUID(), uid, b.build());
        }
    }

    public JSONObject getPayload(Bundle data) {
        String payloadStr = data.getString(KEY_PAYLOAD);
        try {
            JSONObject payload = new JSONObject(payloadStr);
            return payload;
        }
        catch (JSONException e) {
            WarpUtils.log("Error with payload", (Exception)((Object)e));
            return null;
        }
    }

    public String getNotificationTitle(Bundle data) {
        return data.getString("alert");
    }

    public String getNotificationMessage(Bundle data) {
        return data.getString(KEY_MESSAGE);
    }

    public String getNotificationTicker(Bundle data) {
        return data.getString("alert");
    }

    public String getNotificationSubtitle(Bundle data) {
        return data.getString(KEY_SUBTITLE);
    }

    private static Bitmap loadDrawable(String url) {
        if (url == null || TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            InputStream is = entity.getContent();
            if (is == null) {
                entity.consumeContent();
                return null;
            }
            Bitmap b = BitmapFactory.decodeStream((InputStream)is);
            is.close();
            entity.consumeContent();
            WarpUtils.log("Notification Large Icon Loading: success" + url);
            return b;
        }
        catch (IOException e) {
            WarpUtils.log("Notification Large Icon Loading: ", e);
            return null;
        }
    }

    private void getSmallIcon(Context context, PushCampaign pc) {
    }
}

