/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import ly.warp.sdk.receivers.WarplyInAppNotificationReceiver;
import ly.warp.sdk.services.WarpBaseIntentService;
import ly.warp.sdk.utils.WarplyProperty;

public class WarpInAppNotificationService
extends WarpBaseIntentService {
    public static final String KEY_UID = "uid";
    public static final String KEY_TITLE = "title";
    public static final String KEY_SUBTITLE = "subtitle";
    public static final String KEY_BUTTON = "button";
    public static final String KEY_HEADS_UP = "heads_up";
    private final String TAG_NOTIFICATION = "notification";

    public void onHandleIntent(Intent intent) {
        int uid = intent.getIntExtra(KEY_UID, 0);
        String mNotificationTitle = intent.getStringExtra(KEY_TITLE);
        String mNotificationSubtitle = intent.getStringExtra(KEY_SUBTITLE);
        boolean mIsHeadsUp = intent.getBooleanExtra(KEY_HEADS_UP, false);
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this);
        PackageManager pm = this.getPackageManager();
        builder.setContentTitle((CharSequence)mNotificationTitle);
        builder.setContentText((CharSequence)mNotificationSubtitle);
        builder.setSmallIcon(WarplyProperty.getPushIconResId((Context)this));
        builder.setVisibility(1);
        builder.setAutoCancel(true);
        builder.setDefaults(-1);
        if (mIsHeadsUp) {
            builder.setPriority(1);
        } else {
            builder.setPriority(0);
        }
        Intent notifyIntent = pm.getLaunchIntentForPackage(this.getPackageName()).putExtra(KEY_UID, uid).putExtra(KEY_TITLE, mNotificationTitle).putExtra(KEY_SUBTITLE, mNotificationSubtitle);
        PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)this, (int)uid, (Intent)notifyIntent, (int)0xA000000) : PendingIntent.getBroadcast((Context)this, (int)uid, (Intent)notifyIntent, (int)0x8000000);
        builder.setContentIntent(pendingIntent);
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        Notification notification_build = builder.build();
        notification_build.flags = 16;
        nm.notify("notification", uid, notification_build);
    }

    public static void createInAppNotificationAlarm(Context context, @NonNull int uid, long interval, String title, String subtitle, boolean isHeadsUpNotification) {
        Intent notifyIntent = new Intent(context, WarplyInAppNotificationReceiver.class).putExtra(KEY_UID, uid).putExtra(KEY_TITLE, title).putExtra(KEY_SUBTITLE, subtitle).putExtra(KEY_HEADS_UP, isHeadsUpNotification);
        PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)context, (int)uid, (Intent)notifyIntent, (int)0xA000000) : PendingIntent.getBroadcast((Context)context, (int)uid, (Intent)notifyIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.setRepeating(0, System.currentTimeMillis(), interval, pendingIntent);
    }

    public static void cancelInAppNotificationAlarm(Context context, @NonNull int uid) {
        Intent notifyIntent = new Intent(context, WarplyInAppNotificationReceiver.class).putExtra(KEY_UID, uid);
        PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)context, (int)uid, (Intent)notifyIntent, (int)0x12000000) : PendingIntent.getBroadcast((Context)context, (int)uid, (Intent)notifyIntent, (int)0x10000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.cancel(pendingIntent);
        pendingIntent.cancel();
    }

    public static boolean checkIfAlarmIsActive(Context context, int uid) {
        Intent checkIntent = new Intent(context, WarplyInAppNotificationReceiver.class).putExtra(KEY_UID, uid);
        return PendingIntent.getBroadcast((Context)context, (int)uid, (Intent)checkIntent, (int)0x20000000) != null;
    }
}

