/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.BeaconMessage;
import ly.warp.sdk.io.models.PushCampaign;
import ly.warp.sdk.receivers.WarplyBeaconsApplication;
import ly.warp.sdk.services.WarpBaseIntentService;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyBeaconsRangingService
extends Service
implements BeaconConsumer {
    private static final String KEY_STATUS = "status";
    private static final String KEY_CONTEXT = "context";
    private static final String KEY_MAPP_BEACON = "MAPP_BEACON";
    private static final int mResponseStatusOk = 1;
    private final IBinder mBinder = new BeaconsRangingServiceBinder();
    private BeaconManager mBeaconManager;
    private Map<String, Long> mSentBeacons = Collections.synchronizedMap(new HashMap());
    private int mMinDistanceToSend = 0;
    private long mMinTimeToSend = 0L;
    private Handler mSendMessageHandler;
    private CountDownLatch mSendMessageLatch;

    public void onCreate() {
        super.onCreate();
        Warply.getInitializer((Context)this).init();
        this.mBeaconManager = BeaconManager.getInstanceForApplication((Context)this.getApplicationContext());
        this.startBeaconListener();
        HandlerThread thread = new HandlerThread("WarplyBeaconsRangingServiceThread");
        thread.start();
        this.mSendMessageHandler = new Handler(thread.getLooper());
        WarpUtils.log("WarplyBeacons: RangingService : onCreate");
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopBeaconListener();
        WarpUtils.log("WarplyBeacons: RangingService : onDestroy");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mBeaconManager.setForegroundScanPeriod(WarplyBeaconsApplication.getBeaconScanPeriod());
        if (this.mBeaconManager.isBound((BeaconConsumer)this)) {
            this.mBeaconManager.setBackgroundMode(false);
        }
        this.mMinDistanceToSend = WarplyBeaconsApplication.getBeaconDistanceToSendWarply();
        this.mMinTimeToSend = WarplyBeaconsApplication.getBeaconTimeIntervalToSendWarply();
        WarpUtils.log("WarplyBeacons: RangingService : onStartCommand");
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public void onBeaconServiceConnect() {
        block2: {
            this.mBeaconManager.setRangeNotifier(new RangeNotifier(){

                public void didRangeBeaconsInRegion(Collection<Beacon> beacons, Region region) {
                    if (beacons.size() > 0) {
                        WarpUtils.log("WarplyBeacons: RangingService : didRangeBeaconsInRegion");
                        WarplyBeaconsRangingService.this.sendBeaconMessageToWarplyServer(beacons.iterator().next());
                    }
                }
            });
            try {
                this.mBeaconManager.startRangingBeaconsInRegion(new Region("RangingRegion", null, null, null));
            }
            catch (RemoteException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private synchronized void sendBeaconMessageToWarplyServer(Beacon beacon) {
        if (beacon != null && beacon.getDistance() <= (double)this.mMinDistanceToSend) {
            this.await();
            this.mSendMessageHandler.post((Runnable)new SendMessageRunnable(beacon));
        }
    }

    private void await() {
        block3: {
            if (this.mSendMessageLatch != null) {
                try {
                    this.mSendMessageLatch.await();
                }
                catch (InterruptedException e) {
                    if (!WarpConstants.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    private void lock() {
        if (this.mSendMessageLatch == null || this.mSendMessageLatch.getCount() == 0L) {
            this.mSendMessageLatch = new CountDownLatch(1);
        }
    }

    private void unlock() {
        if (this.mSendMessageLatch != null) {
            this.mSendMessageLatch.countDown();
        }
    }

    private void showNotification(JSONObject response) {
        block4: {
            String pushParams;
            JSONObject json;
            if (response != null && response.optInt(KEY_STATUS) == 1 && (json = response.optJSONObject(KEY_CONTEXT)) != null && !TextUtils.isEmpty((CharSequence)(pushParams = json.optString(KEY_MAPP_BEACON)))) {
                try {
                    pushParams = pushParams.substring(1, pushParams.length() - 1);
                    json = new JSONObject(pushParams);
                    final PushCampaign pc = new PushCampaign(json);
                    if (pc.isFilled()) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                WarpBaseIntentService.showCampaignNotification((Context)WarplyBeaconsRangingService.this, pc);
                            }
                        }).start();
                    }
                }
                catch (JSONException e) {
                    if (!WarpConstants.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    public void startBeaconListener() {
        WarpUtils.log("WarplyBeacons: RangingService : startBeaconListener");
        this.mBeaconManager.bind((BeaconConsumer)this);
    }

    public void stopBeaconListener() {
        WarpUtils.log("WarplyBeacons: RangingService : stopBeaconListener");
        this.mBeaconManager.unbind((BeaconConsumer)this);
    }

    public class BeaconsRangingServiceBinder
    extends Binder {
        public WarplyBeaconsRangingService getService() {
            return WarplyBeaconsRangingService.this;
        }
    }

    private class SendMessageRunnable
    implements Runnable {
        private Beacon mSendBeacon;

        public SendMessageRunnable(Beacon beacon) {
            this.mSendBeacon = beacon;
        }

        @Override
        public void run() {
            BeaconMessage beaconMessage = new BeaconMessage(this.mSendBeacon);
            String messageSignature = beaconMessage.getSignature();
            Long lastSendTimeForBeacon = (Long)WarplyBeaconsRangingService.this.mSentBeacons.get(messageSignature);
            if (lastSendTimeForBeacon == null) {
                lastSendTimeForBeacon = 0L;
            }
            if ((System.nanoTime() - lastSendTimeForBeacon) / 1000000L > WarplyBeaconsRangingService.this.mMinTimeToSend) {
                WarpUtils.log("WarplyBeacons: RangingService : post beacon: " + messageSignature + " " + this.mSendBeacon.getDistance());
                final String messageSignatureFinal = messageSignature;
                Warply.postReceiveMicroappData("beacon", beaconMessage.toJson(), new CallbackReceiver<JSONObject>(){

                    @Override
                    public void onSuccess(JSONObject jsonObject) {
                        WarplyBeaconsRangingService.this.showNotification(jsonObject);
                        WarplyBeaconsRangingService.this.mSentBeacons.put(messageSignatureFinal, System.nanoTime());
                        WarpUtils.log("WarplyBeacons: RangingService : post beacon: " + messageSignatureFinal + " (success)");
                        WarplyBeaconsRangingService.this.unlock();
                    }

                    @Override
                    public void onFailure(int i) {
                        WarpUtils.log("WarplyBeacons: RangingService : post beacon: " + messageSignatureFinal + " (failure)=" + i);
                        WarplyBeaconsRangingService.this.unlock();
                    }
                });
                WarplyBeaconsRangingService.this.lock();
            }
        }
    }
}

