/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import ly.warp.sdk.R;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.HealthEventModel;
import ly.warp.sdk.io.models.PacingDetails;
import ly.warp.sdk.io.request.PacingCalculateRequest;
import ly.warp.sdk.io.request.PacingDetailsRequest;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

public class WarplyHealthService
extends Service
implements SensorEventListener {
    private static final String STEPS_CHANNEL_ID = "stepschannel";
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private final int ACCEL_RING_SIZE = 50;
    private final int VEL_RING_SIZE = 10;
    private final float STEP_THRESHOLD = 20.0f;
    private final int STEP_DELAY_NS = 250000000;
    private int accelRingCounter = 0;
    private float[] accelRingX = new float[50];
    private float[] accelRingY = new float[50];
    private float[] accelRingZ = new float[50];
    private int velRingCounter = 0;
    private float[] velRing = new float[10];
    private long lastStepTimeNs = 0L;
    private float oldVelocityEstimate = 0.0f;
    private double eventMeters = 0.0;
    private double pacingMeters = 0.0;
    private int sumSteps = 0;
    private CallbackReceiver<PacingDetails> mPacingCallback = new CallbackReceiver<PacingDetails>(){

        @Override
        public void onSuccess(PacingDetails result) {
            WarplyHealthService.this.pacingMeters = result.getMeters().getDay().getValue();
            WarplyHealthService.this.registerStepSensor();
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public void onCreate() {
        super.onCreate();
        this.mSensorManager = (SensorManager)this.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        Warply.getInitializer(this.getApplicationContext()).init();
        WarplyManager.getPacingDetails(new PacingDetailsRequest(), this.mPacingCallback);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        PackageManager pm = this.getPackageManager();
        Intent bIntent = pm.getLaunchIntentForPackage(this.getPackageName());
        PendingIntent pbIntent = PendingIntent.getActivity((Context)this, (int)2001, (Intent)bIntent, (int)0x4000000);
        NotificationCompat.Builder b = new NotificationCompat.Builder((Context)this, STEPS_CHANNEL_ID);
        b.setDefaults(6);
        b.setChannelId(STEPS_CHANNEL_ID);
        b.setContentTitle((CharSequence)this.getString(R.string.cos_steps_for_good_notification_title));
        b.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)this.getString(R.string.cos_steps_for_good_notification_subtitle)));
        b.setContentIntent(pbIntent);
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setSmallIcon(R.drawable.ic_launcher);
        if (notificationManager != null) {
            if (Build.VERSION.SDK_INT >= 34) {
                NotificationChannel notificationChannel = new NotificationChannel(STEPS_CHANNEL_ID, (CharSequence)"steps_notification_channel", 3);
                notificationManager.createNotificationChannel(notificationChannel);
                Notification notification_build = b.setChannelId(STEPS_CHANNEL_ID).build();
                this.startForeground(2001, notification_build, 256);
            } else if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel notificationChannel = new NotificationChannel(STEPS_CHANNEL_ID, (CharSequence)"steps_notification_channel", 3);
                notificationManager.createNotificationChannel(notificationChannel);
                Notification notification_build = b.setChannelId(STEPS_CHANNEL_ID).build();
                this.startForeground(2001, notification_build);
            } else {
                Notification notification_build = b.build();
                this.startForeground(2001, notification_build);
            }
        }
        new Thread(() -> {
            while (true) {
                this.sendSteps();
                try {
                    Thread.sleep(900000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterStepSensor();
        WarplyManagerHelper.mStepsWebview = 0;
        WarplyManagerHelper.mMetersWebview = 0.0;
        this.eventMeters = 0.0;
        this.pacingMeters = 0.0;
        this.sumSteps = 0;
        this.sendSteps();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 1) {
            this.updateSteps(sensorEvent.timestamp, sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2]);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    public void registerStepSensor() {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 1);
    }

    public void unregisterStepSensor() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    private void updateSteps(long timeNs, float x, float y, float z) {
        float[] currentAccel = new float[]{x, y, z};
        ++this.accelRingCounter;
        this.accelRingX[this.accelRingCounter % 50] = currentAccel[0];
        this.accelRingY[this.accelRingCounter % 50] = currentAccel[1];
        this.accelRingZ[this.accelRingCounter % 50] = currentAccel[2];
        float[] worldZ = new float[]{this.sum(this.accelRingX) / (float)Math.min(this.accelRingCounter, 50), this.sum(this.accelRingY) / (float)Math.min(this.accelRingCounter, 50), this.sum(this.accelRingZ) / (float)Math.min(this.accelRingCounter, 50)};
        float normalization_factor = this.norm(worldZ);
        worldZ[0] = worldZ[0] / normalization_factor;
        worldZ[1] = worldZ[1] / normalization_factor;
        worldZ[2] = worldZ[2] / normalization_factor;
        float currentZ = this.dot(worldZ, currentAccel) - normalization_factor;
        ++this.velRingCounter;
        this.velRing[this.velRingCounter % 10] = currentZ;
        float velocityEstimate = this.sum(this.velRing);
        if (velocityEstimate > 20.0f && this.oldVelocityEstimate <= 20.0f && timeNs - this.lastStepTimeNs > 250000000L) {
            ++this.sumSteps;
            WarpUtils.log("COUNT_STEPS: " + String.valueOf(++WarplyManagerHelper.mSteps));
            WarpUtils.setStepsCounter((Context)this, WarplyManagerHelper.mSteps);
            WarplyManagerHelper.mMetersWebview = (double)(++WarplyManagerHelper.mStepsWebview) * 0.762;
            WarpUtils.log("WEBVIEW_METERS: " + String.valueOf(WarplyManagerHelper.mMetersWebview));
            HealthEventModel healthSteps = new HealthEventModel();
            this.eventMeters = (double)this.sumSteps * 0.762;
            WarpUtils.log("WIDGET_METERS: " + String.valueOf(this.pacingMeters + this.eventMeters));
            healthSteps.setMeters(this.pacingMeters + this.eventMeters);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(healthSteps));
            this.lastStepTimeNs = timeNs;
        }
        this.oldVelocityEstimate = velocityEstimate;
    }

    private float sum(float[] array) {
        float retval = 0.0f;
        for (float v : array) {
            retval += v;
        }
        return retval;
    }

    private float[] cross(float[] arrayA, float[] arrayB) {
        float[] retArray = new float[]{arrayA[1] * arrayB[2] - arrayA[2] * arrayB[1], arrayA[2] * arrayB[0] - arrayA[0] * arrayB[2], arrayA[0] * arrayB[1] - arrayA[1] * arrayB[0]};
        return retArray;
    }

    private float norm(float[] array) {
        float retval = 0.0f;
        for (float v : array) {
            retval += v * v;
        }
        return (float)Math.sqrt(retval);
    }

    private float dot(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private float[] normalize(float[] a) {
        float[] retval = new float[a.length];
        float norm = this.norm(a);
        for (int i = 0; i < a.length; ++i) {
            retval[i] = a[i] / norm;
        }
        return retval;
    }

    private void sendSteps() {
        String date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.getDefault()).format(new Date());
        if (WarpUtils.getStepsCounter((Context)this) > 0) {
            WarplyManager.setPacingDetails(new PacingCalculateRequest().setCounter(WarpUtils.getStepsCounter((Context)this)).setDate(date), new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    int status = result.optInt("status", 2);
                    if (status == 1) {
                        WarplyManagerHelper.mSteps = 0;
                        WarpUtils.setStepsCounter((Context)WarplyHealthService.this, 0);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    WarpUtils.log("Warply Health Service error: " + String.valueOf(errorCode));
                }
            });
        }
    }
}

