/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;
import ly.warp.sdk.utils.constants.WarpConstants;

public class GoogleAdInfoClient {
    public static GoogleAdInfo getGoogleAdvertisingInfo(Context context) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        GoogleAdInfo info = GoogleAdInfoClient.firstTry(context);
        if (info == null) {
            info = GoogleAdInfoClient.secondTry(context);
        }
        return info;
    }

    private static GoogleAdInfo firstTry(Context context) {
        try {
            Class<?> GooglePlayServicesUtil = Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
            Method isGooglePlayServicesAvailable = GooglePlayServicesUtil.getMethod("isGooglePlayServicesAvailable", Context.class);
            if (isGooglePlayServicesAvailable.invoke(null, context).equals(0)) {
                Class<?> AdvertisingClientId = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                Method getAdvertisingIdInfo = AdvertisingClientId.getMethod("getAdvertisingIdInfo", Context.class);
                Object advertisingTrackingInfo = getAdvertisingIdInfo.invoke(null, context);
                Class<?> Info2 = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient$Info");
                Method getId = Info2.getMethod("getId", new Class[0]);
                String id2 = (String)getId.invoke(advertisingTrackingInfo, new Object[0]);
                Method isLimitAdTrackingEnabled = Info2.getMethod("isLimitAdTrackingEnabled", new Class[0]);
                boolean limitAdTrackingEnabled = (Boolean)isLimitAdTrackingEnabled.invoke(advertisingTrackingInfo, new Object[0]);
                return new GoogleAdInfo(id2, limitAdTrackingEnabled);
            }
            return null;
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GoogleAdInfo secondTry(Context context) {
        AdServiceConnection adServiceConnection = null;
        try {
            adServiceConnection = new AdServiceConnection();
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            if (context.bindService(intent, (ServiceConnection)adServiceConnection, 1)) {
                GoogleAdInfoFetcher adInfoFetcher = new GoogleAdInfoFetcher(adServiceConnection.getBinder());
                GoogleAdInfo googleAdInfo = adInfoFetcher.fetch();
                return googleAdInfo;
            }
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            if (adServiceConnection != null) {
                context.unbindService((ServiceConnection)adServiceConnection);
            }
        }
        return null;
    }

    public static final class GoogleAdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        GoogleAdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
            this.advertisingId = advertisingId;
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.advertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }

    private static class AdServiceConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> bindersQueue = new LinkedBlockingQueue(1);

        private AdServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            block2: {
                try {
                    this.bindersQueue.put(service);
                }
                catch (InterruptedException e) {
                    if (!WarpConstants.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.bindersQueue.take();
        }
    }

    private static class GoogleAdInfoFetcher
    implements IInterface {
        private IBinder mPlayServicesBinder;

        public GoogleAdInfoFetcher(IBinder playServicesBinder) {
            this.mPlayServicesBinder = playServicesBinder;
        }

        public IBinder asBinder() {
            return this.mPlayServicesBinder;
        }

        public GoogleAdInfo fetch() {
            return new GoogleAdInfo(this.getId(), this.isLimitAdTrackingEnabled(true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getId() {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            String id2 = "";
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.mPlayServicesBinder.transact(1, data, reply, 0);
                reply.readException();
                id2 = reply.readString();
            }
            catch (RemoteException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isLimitAdTrackingEnabled(boolean paramBoolean) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            boolean limitAdTracking = false;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.mPlayServicesBinder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            catch (RemoteException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }
}

