/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ly.warp.sdk.utils.constants.WarpConstants;

public class ObjectSerializer {
    private static final String WARPLY_SERIALIZE_CACHE_DIR = "WarplyCache";
    private Context mContext;

    public ObjectSerializer(Context context) {
        this.mContext = context;
    }

    public static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String externalStorageDirectory(Context context) {
        File dir;
        if (ObjectSerializer.externalMemoryAvailable() && context != null && (dir = context.getExternalFilesDir(null)) != null) {
            return dir.getPath();
        }
        return null;
    }

    public String getCachePath() {
        String externalDir = ObjectSerializer.externalStorageDirectory(this.mContext);
        if (externalDir != null) {
            return externalDir + File.separator + WARPLY_SERIALIZE_CACHE_DIR;
        }
        return null;
    }

    public String getPathInCache(String pathInsideCache) {
        String cachePath = this.getCachePath();
        if (cachePath != null && cachePath.length() > 0) {
            return cachePath + File.separator + pathInsideCache;
        }
        return null;
    }

    public File getCacheFile(String pathInsideCache) {
        File file;
        block3: {
            file = null;
            try {
                String cachePath = this.getPathInCache(pathInsideCache);
                if (cachePath != null) {
                    file = new File(cachePath);
                }
            }
            catch (Exception e) {
                if (!WarpConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return file;
    }

    public boolean prepareDirInCache(String path) throws IOException {
        try {
            String cachePath = this.getCachePath();
            if (TextUtils.isEmpty((CharSequence)cachePath)) {
                return false;
            }
            File f = new File(cachePath);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (path != null && path.length() > 0 && path.length() > cachePath.length()) {
                int lastSeparatorIndex = path.lastIndexOf(File.separator);
                String pathWithoutFile = "";
                if (lastSeparatorIndex > cachePath.length() + 1) {
                    pathWithoutFile = path.substring(cachePath.length() + 1, lastSeparatorIndex);
                }
                if (!new File(cachePath + File.separator + pathWithoutFile).exists()) {
                    String[] folders = pathWithoutFile.split(File.separator);
                    String currPathFolder = cachePath;
                    for (String folder : folders) {
                        f = new File(currPathFolder = currPathFolder + File.separator + folder);
                        if (f.exists()) continue;
                        f.mkdirs();
                    }
                }
            }
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean serialize(Object o, String pathInsideCache) {
        block3: {
            try {
                File outputFile;
                if (this.prepareDirInCache(pathInsideCache) && (outputFile = this.getCacheFile(pathInsideCache)) != null) {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outputFile));
                    oos.writeObject(o);
                    oos.flush();
                    oos.close();
                    return true;
                }
            }
            catch (Exception ex) {
                if (!WarpConstants.DEBUG) break block3;
                ex.printStackTrace();
            }
        }
        return false;
    }

    public Object deserialize(String pathInsideCache) {
        block3: {
            try {
                File f = this.getCacheFile(pathInsideCache);
                if (f != null) {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                    Object o = ois.readObject();
                    ois.close();
                    return o;
                }
            }
            catch (Exception ex) {
                if (!WarpConstants.DEBUG) break block3;
                ex.printStackTrace();
            }
        }
        return null;
    }
}

