/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import java.lang.ref.WeakReference;
import java.util.List;
import ly.warp.sdk.dexter.Dexter;
import ly.warp.sdk.dexter.DexterBuilder;
import ly.warp.sdk.dexter.MultiplePermissionsReport;
import ly.warp.sdk.dexter.PermissionToken;
import ly.warp.sdk.dexter.listener.DexterError;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.dexter.listener.PermissionRequest;
import ly.warp.sdk.dexter.listener.PermissionRequestErrorListener;
import ly.warp.sdk.dexter.listener.multi.MultiplePermissionsListener;
import ly.warp.sdk.utils.WarplyPreferences;

public class PermissionsUtil {
    private static final int SLEEP_TIME = 5000;
    public static final String PERMISSION_LOCATION_FINE = "android.permission.ACCESS_FINE_LOCATION";
    public static final String PERMISSION_LOCATION_COARSE = "android.permission.ACCESS_COARSE_LOCATION";
    public static final String PERMISSION_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    public static final String SAFE_PERMISSION_BLUETOOTH = "android.permission.BLUETOOTH";
    private static final String[] DANGEROUS_PERMISSIONS = new String[0];
    private WeakReference<Context> context;
    private String[] requestedPerms;
    private PermissionCallback callback;
    private WarplyPreferences prefs;
    private Handler handler;

    public PermissionsUtil(@NonNull Context context, @Nullable PermissionCallback callback, String ... requestedPerms) {
        this.prefs = new WarplyPreferences(context);
        this.context = new WeakReference<Context>(context);
        this.callback = callback;
        this.requestedPerms = requestedPerms;
        if (this.requestedPerms == null) {
            this.requestedPerms = DANGEROUS_PERMISSIONS;
        }
        HandlerThread mHandlerThread = new HandlerThread("PermissionsUtil");
        mHandlerThread.start();
        this.handler = new Handler(mHandlerThread.getLooper());
    }

    public boolean requestNeeded() {
        for (String p : this.requestedPerms) {
            if (PermissionsUtil.hasPermission((Context)this.context.get(), p)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPermission(Context con, String permission2) {
        return ContextCompat.checkSelfPermission((Context)con, (String)permission2) == 0;
    }

    public void requestPermissions() {
        final DexterBuilder builder = Dexter.withContext((Context)this.context.get()).withPermissions(this.requestedPerms).withListener(new MultiplePermissionsListener(){

            @Override
            public void onPermissionsChecked(MultiplePermissionsReport report) {
                if (PermissionsUtil.this.callback != null) {
                    if (report.areAllPermissionsGranted()) {
                        PermissionsUtil.this.callback.onPermissionsGranted();
                    } else {
                        PermissionsUtil.this.callback.onPermissionDenied(report.getDeniedPermissionResponses());
                    }
                }
            }

            @Override
            public void onPermissionRationaleShouldBeShown(List<PermissionRequest> permissions, PermissionToken token) {
                token.continuePermissionRequest();
            }
        }).withErrorListener(new PermissionRequestErrorListener(){

            @Override
            public void onError(DexterError error) {
                if (PermissionsUtil.this.callback != null) {
                    PermissionsUtil.this.callback.onError(error);
                }
            }
        }).onSameThread();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                while (!PermissionsUtil.this.prefs.isForeground()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                builder.check();
            }
        });
    }

    public static interface PermissionCallback {
        public void onPermissionDenied(List<PermissionDeniedResponse> var1);

        public void onPermissionsGranted();

        public void onError(DexterError var1);
    }
}

