/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import java.lang.ref.WeakReference;
import ly.warp.sdk.utils.WarpUtils;

public class PrefsUtils {
    private static final String FILE_SECURE_SHARED_PREFS = "com.gr.gapp.obfuscatepreferences";
    private static final String KEY_ACC_TOKEN = "key_acc_token";
    private static final String KEY_REF_TOKEN = "key_ref_token";
    private static final String KEY_CL_SECRET = "key_cl_secret";
    private static final String KEY_CID = "key_cid";
    private static WeakReference<Application> sContext;
    private static SharedPreferences mSecurePref;

    public static void initialize(Application application) {
        sContext = new WeakReference<Application>(application);
    }

    private static SharedPreferences getPrefs() {
        return PreferenceManager.getDefaultSharedPreferences((Context)((Context)sContext.get()));
    }

    private static SharedPreferences getPrefs(Context context) {
        try {
            MasterKey masterKey = new MasterKey.Builder(context, "_androidx_security_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
            SharedPreferences encryptedSharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)(context.getPackageName() + "_preferences"), (MasterKey)masterKey, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
            return encryptedSharedPreferences;
        }
        catch (Exception e) {
            WarpUtils.log("PrefUtils Get Encrypted Shared Preferences Error", e);
            return PreferenceManager.getDefaultSharedPreferences((Context)context);
        }
    }

    public static void clearPrefs() {
        PrefsUtils.getPrefs().edit().clear().apply();
    }

    public static String getAccToken(Context context) {
        return PrefsUtils.getPrefs(context).getString(KEY_ACC_TOKEN, "");
    }

    public static void setAccToken(Context context, String at) {
        PrefsUtils.getPrefs(context).edit().putString(KEY_ACC_TOKEN, at).apply();
    }

    public static String getRefToken(Context context) {
        return PrefsUtils.getPrefs(context).getString(KEY_REF_TOKEN, "");
    }

    public static void setRefToken(Context context, String rt) {
        PrefsUtils.getPrefs(context).edit().putString(KEY_REF_TOKEN, rt).apply();
    }

    public static String getClSecret(Context context) {
        return PrefsUtils.getPrefs(context).getString(KEY_CL_SECRET, "");
    }

    public static void setClSecret(Context context, String cs) {
        PrefsUtils.getPrefs(context).edit().putString(KEY_CL_SECRET, cs).apply();
    }

    public static String getCid(Context context) {
        return PrefsUtils.getPrefs(context).getString(KEY_CID, "");
    }

    public static void setCid(Context context, String cid) {
        PrefsUtils.getPrefs(context).edit().putString(KEY_CID, cid).apply();
    }
}

