/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONObject;

public class WarpJSONParser {
    public static String getStringFromJSON(JSONObject jObject, String string2, String defaultValue) {
        String jString = defaultValue;
        try {
            jString = jObject.getString(string2);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            jString = defaultValue;
        }
        return jString;
    }

    public static JSONObject getJSONFromString(String value) {
        JSONObject jObject;
        block2: {
            jObject = new JSONObject();
            try {
                jObject = new JSONObject(value);
            }
            catch (Exception e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObject;
    }

    public static JSONObject getJObjectFromJSON(JSONObject jObject, String key) {
        JSONObject object;
        block2: {
            object = new JSONObject();
            try {
                object = jObject.getJSONObject(key);
            }
            catch (Exception e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return object;
    }

    public static String getStringFromJSONArray(JSONArray jArray, int index, String defaultValue) {
        String string2 = defaultValue;
        try {
            string2 = jArray.getString(index);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            string2 = defaultValue;
        }
        return string2;
    }

    public static JSONArray getJSONArrayFromJson(JSONObject jObject, String string2) {
        JSONArray jArray;
        block2: {
            jArray = new JSONArray();
            try {
                jArray = jObject.getJSONArray(string2);
            }
            catch (Exception e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jArray;
    }

    public static JSONObject getJObjectFromJArray(JSONArray jArray, int index) {
        JSONObject jObject;
        block2: {
            jObject = new JSONObject();
            try {
                jObject = jArray.getJSONObject(index);
            }
            catch (Exception e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObject;
    }

    public static int getIntFromJSONObject(JSONObject jObject, String string2, int defaultValue) {
        int value = defaultValue;
        try {
            value = jObject.getInt(string2);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            value = defaultValue;
        }
        return value;
    }

    public static long getLongFromJSONObject(JSONObject jObject, String string2, long defaultValue) {
        long value = defaultValue;
        try {
            value = jObject.getLong(string2);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            value = defaultValue;
        }
        return value;
    }

    public static double getDoubleFromJSONObject(JSONObject jObject, String string2, double defaultValue) {
        double value = defaultValue;
        try {
            value = jObject.getDouble(string2);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            value = defaultValue;
        }
        return value;
    }

    public static float getFloatFromJSONObject(JSONObject jObject, String string2, float defaultValue) {
        float value = defaultValue;
        try {
            value = (float)jObject.getDouble(string2);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            value = defaultValue;
        }
        return value;
    }

    public static boolean getBooleanFromJSONObject(JSONObject jObject, String string2, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = jObject.getBoolean(string2);
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            value = defaultValue;
        }
        return value;
    }

    public static JSONObject createJSONObjectFromString(String key, String value) {
        JSONObject jObject = new JSONObject();
        try {
            jObject.putOpt(key, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jObject;
    }

    @NonNull
    public static <T> List<T> parseJsonToList(JSONObject json, String arrayName, Class<T> targetClass) {
        JSONArray jArray = null;
        if (json != null) {
            jArray = json.optJSONArray(arrayName);
        }
        return WarpJSONParser.parseJsonToList(jArray, targetClass);
    }

    @NonNull
    public static <T> List<T> parseJsonToList(JSONArray json, Class<T> targetClass) {
        if (json == null) {
            return new ArrayList(0);
        }
        ArrayList<Object> values = new ArrayList<Object>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            try {
                T model = targetClass.getConstructor(JSONObject.class).newInstance(json.optJSONObject(i));
                values.add(model);
                continue;
            }
            catch (Exception e) {
                try {
                    values.add(json.opt(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return values;
    }
}

