/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.utils.GoogleAdInfoClient;
import ly.warp.sdk.utils.PermissionsUtil;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyDeviceInfoCollector {
    private final Context mContext;

    public WarplyDeviceInfoCollector(Context context) {
        this.mContext = context;
        if (context instanceof Activity) {
            new PermissionsUtil((Context)((Activity)context), null, "android.permission.READ_PHONE_STATE").requestPermissions();
        }
    }

    public void collectToJson(SimpleCallbackReceiver<JSONObject> callback) {
        JSONObject jObj = new JSONObject();
        new Thread(() -> {
            if (!Thread.currentThread().isInterrupted()) {
                if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.mContext) == 0) {
                    try {
                        if (WarpUtils.getTrackersEnabled(this.mContext)) {
                            jObj.putOpt("platform", (Object)"android");
                            jObj.putOpt("manufacturer", (Object)this.getDeviceManufacturer());
                            jObj.putOpt("android_phone_model", (Object)this.getDeviceModel());
                            jObj.putOpt("os_version", (Object)this.getOsVersion());
                            jObj.putOpt("app_version", (Object)this.getAppVersion());
                        }
                        jObj.putOpt("registration_gcm", (Object)this.getRegistrationGCM());
                        jObj.putOpt("vendor", (Object)"google");
                        jObj.putOpt("unique_device_id", (Object)this.getUniqueDeviceId());
                    }
                    catch (JSONException e) {
                        WarpUtils.log("************* WARPLY Warning ********************");
                        WarpUtils.log("Problem when creating Device Info JSON", (Exception)((Object)e));
                        WarpUtils.log("*************************************************");
                    }
                } else {
                    try {
                        if (WarpUtils.getTrackersEnabled(this.mContext)) {
                            jObj.putOpt("platform", (Object)"android");
                            jObj.putOpt("manufacturer", (Object)this.getDeviceManufacturer());
                            jObj.putOpt("android_phone_model", (Object)this.getDeviceModel());
                            jObj.putOpt("os_version", (Object)this.getOsVersion());
                            jObj.putOpt("app_version", (Object)this.getAppVersion());
                        }
                        jObj.putOpt("vendor", (Object)"huawei");
                        jObj.putOpt("registration_gcm", (Object)this.getRegistrationGCM());
                        jObj.putOpt("unique_device_id", (Object)this.getUniqueDeviceId());
                    }
                    catch (JSONException e) {
                        WarpUtils.log("************* WARPLY Warning ********************");
                        WarpUtils.log("Problem when creating Device Info JSON", (Exception)((Object)e));
                        WarpUtils.log("*************************************************");
                    }
                }
            }
            callback.onSuccess(jObj);
            Thread.currentThread().interrupt();
        }).start();
    }

    public void getRegistrationParams(SimpleCallbackReceiver<JSONObject> callback) {
        JSONObject jObj = new JSONObject();
        new Thread(() -> {
            if (!Thread.currentThread().isInterrupted()) {
                if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.mContext) == 0) {
                    try {
                        if (WarpUtils.getTrackersEnabled(this.mContext)) {
                            jObj.putOpt("platform", (Object)"android");
                            jObj.putOpt("manufacturer", (Object)this.getDeviceManufacturer());
                            jObj.putOpt("android_phone_model", (Object)this.getDeviceModel());
                            jObj.putOpt("os_version", (Object)this.getOsVersion());
                            jObj.putOpt("app_version", (Object)this.getAppVersion());
                        }
                        jObj.putOpt("unique_device_id", (Object)this.getUniqueDeviceId());
                        jObj.putOpt("vendor", (Object)"google");
                    }
                    catch (JSONException e) {
                        WarpUtils.log("************* WARPLY Warning ********************");
                        WarpUtils.log("Problem when creating Device Info JSON", (Exception)((Object)e));
                        WarpUtils.log("*************************************************");
                    }
                } else {
                    try {
                        if (WarpUtils.getTrackersEnabled(this.mContext)) {
                            jObj.putOpt("platform", (Object)"android");
                            jObj.putOpt("manufacturer", (Object)this.getDeviceManufacturer());
                            jObj.putOpt("android_phone_model", (Object)this.getDeviceModel());
                            jObj.putOpt("os_version", (Object)this.getOsVersion());
                            jObj.putOpt("app_version", (Object)this.getAppVersion());
                        }
                        jObj.putOpt("unique_device_id", (Object)this.getUniqueDeviceId());
                        jObj.putOpt("vendor", (Object)"huawei");
                    }
                    catch (JSONException e) {
                        WarpUtils.log("************* WARPLY Warning ********************");
                        WarpUtils.log("Problem when creating Registration Device Info JSON", (Exception)((Object)e));
                        WarpUtils.log("*************************************************");
                    }
                }
            }
            callback.onSuccess(jObj);
            Thread.currentThread().interrupt();
        }).start();
    }

    private String hashToString(int value) {
        String result = "";
        String string2 = Integer.toHexString(value);
        int remain = 8 - string2.length();
        char[] chars = new char[remain];
        Arrays.fill(chars, '0');
        string2 = new String(chars) + string2;
        int count = 0;
        for (int i = string2.length() - 1; i >= 0; --i) {
            result = string2.substring(i, i + 1) + result;
            if (++count != 4) continue;
            result = "" + result;
            count = 0;
        }
        return result;
    }

    private String isInDevelopmentMode() {
        return String.valueOf(WarplyProperty.isInDevelopmentMode(this.mContext));
    }

    private String getCarrierName() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        return tm != null ? tm.getNetworkOperatorName() : "";
    }

    private String getRegistrationGCM() {
        if (!TextUtils.isEmpty((CharSequence)WarpUtils.getDeviceToken(this.mContext))) {
            return WarpUtils.getDeviceToken(this.mContext);
        }
        WarpUtils.setDeviceToken(this.mContext, WarpUtils.getRegistrationGCM(this.mContext));
        return WarpUtils.getRegistrationGCM(this.mContext);
    }

    private String getAppVersion() {
        try {
            PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getHardwareId() {
        return Build.SERIAL == null || Build.SERIAL.equals("unknown") ? "" : Build.SERIAL;
    }

    private String getImei() {
        if (!PermissionsUtil.hasPermission(this.mContext, "android.permission.READ_PHONE_STATE")) {
            return "-";
        }
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        try {
            return tm.getDeviceId();
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            return "-";
        }
    }

    private String getAndroidDeviceId() {
        return Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
    }

    private String getBluetoothMac() {
        BluetoothAdapter ba = BluetoothAdapter.getDefaultAdapter();
        String mac = "";
        if (ba != null && PermissionsUtil.hasPermission(this.mContext, "android.permission.BLUETOOTH")) {
            mac = ba.getAddress();
        }
        return mac;
    }

    public String getUniqueDeviceId() {
        byte[] hash;
        block2: {
            String hardwareComplexId = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + (Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS[0].length() % 10 : Build.CPU_ABI.length() % 10) + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
            String hardwareId = this.getHardwareId();
            String androidId = this.getAndroidDeviceId();
            String id2 = hardwareComplexId + hardwareId + androidId;
            hash = id2.getBytes();
            try {
                hash = MessageDigest.getInstance("SHA-256").digest(id2.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return Base64.encodeToString((byte[])hash, (int)2);
    }

    public String getAdvertisementId() {
        if (WarplyDeviceInfoCollector.isPackageInstalled("com.android.vending", this.mContext.getPackageManager())) {
            GoogleAdInfoClient.GoogleAdInfo adInfo = GoogleAdInfoClient.getGoogleAdvertisingInfo(this.mContext);
            return adInfo != null ? adInfo.getId() : "";
        }
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
            return info != null ? info.getId() : "";
        }
        catch (IOException e) {
            return "";
        }
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getDeviceModel() {
        if (!TextUtils.isEmpty((CharSequence)Build.PRODUCT)) {
            return Build.MODEL + " (" + Build.PRODUCT + ")";
        }
        return Build.MODEL;
    }

    private String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    private String getAndroidSDKVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    private String getDeviceName() {
        return Build.DEVICE;
    }

    public int getDisplayHeight() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            wm.getDefaultDisplay().getSize(size);
            return size.y;
        }
        return display.getHeight();
    }

    public int getDisplayWidth() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            wm.getDefaultDisplay().getSize(size);
            return size.x;
        }
        return display.getWidth();
    }

    public JSONObject getInstalledPackages(boolean includeSystemPackages) {
        JSONObject json = new JSONObject();
        JSONArray jsonPacks = new JSONArray();
        List packs = this.mContext.getPackageManager().getInstalledPackages(0);
        for (PackageInfo pack : packs) {
            if (!includeSystemPackages && (pack.versionName == null || pack.packageName.contains("com.android") || pack.packageName.contains("com.google") || pack.packageName.contains(Build.MANUFACTURER.toLowerCase())) || this.mContext.getPackageManager().getLaunchIntentForPackage(pack.packageName) == null) continue;
            try {
                JSONObject jsonPack = new JSONObject();
                jsonPack.putOpt("package_name", (Object)pack.packageName);
                jsonPack.putOpt("app_name", (Object)pack.applicationInfo.loadLabel(this.mContext.getPackageManager()).toString());
                jsonPack.putOpt("app_version", (Object)pack.versionName);
                jsonPacks.put((Object)jsonPack);
            }
            catch (JSONException e) {
                WarpUtils.warn("[WARPLY Packages Installed] Error on JSON creation ", (Exception)((Object)e));
            }
        }
        try {
            json.putOpt("packages_count", (Object)jsonPacks.length());
            json.putOpt("packages", (Object)jsonPacks);
        }
        catch (JSONException e) {
            WarpUtils.warn("[WARPLY Packages Installed] Error on JSON creation ", (Exception)((Object)e));
        }
        return json;
    }

    public static boolean isPackageInstalled(String packageName, PackageManager packageManager) {
        try {
            return packageManager.getApplicationInfo((String)packageName, (int)0).enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isOnline() {
        try {
            int timeoutMs = 1500;
            Socket sock = new Socket();
            InetSocketAddress sockaddr = new InetSocketAddress("8.8.8.8", 53);
            sock.connect(sockaddr, timeoutMs);
            sock.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Single<Boolean> hasInternetConnection() {
        return Single.fromCallable(() -> {
            try {
                int timeoutMs = 1500;
                Socket socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress("8.8.8.8", 53);
                socket.connect(socketAddress, timeoutMs);
                socket.close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 23) {
            Network nw = connectivityManager.getActiveNetwork();
            if (nw == null) {
                return false;
            }
            NetworkCapabilities actNw = connectivityManager.getNetworkCapabilities(nw);
            return actNw != null && (actNw.hasTransport(0) || actNw.hasTransport(1) || actNw.hasTransport(5));
        }
        NetworkInfo nwInfo = connectivityManager.getActiveNetworkInfo();
        return nwInfo != null && nwInfo.isConnected();
    }
}

