/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ly.warp.sdk.dexter.listener.DexterError;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.io.callbacks.WarplyReadyCallback;
import ly.warp.sdk.utils.PermissionsUtil;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;

public class WarplyInitializer
extends Thread {
    private final long INIT_TIME_OUT = 20000L;
    private final long INIT_ATTEMPTS = 3L;
    private final int REQUEST_CODE_ASK_MULTIPLE_PERMISSIONS = 3001;
    private boolean mPermissionsResultRequested = false;
    private Context mContext;
    private Activity mPermissionsActivity;
    private WarplyInitCallback mInitCallback;
    private WarplyReadyCallback mReadyCallback;
    private static volatile Handler mMainThreadHandler;
    private static volatile AtomicBoolean stopThreadLock;

    public WarplyInitializer(Context context, WarplyReadyCallback readyCallback, WarplyInitCallback initCallback) {
        this.mContext = context;
        this.mReadyCallback = readyCallback;
        this.mInitCallback = initCallback;
        if (mMainThreadHandler == null) {
            mMainThreadHandler = new Handler(Looper.getMainLooper());
        }
        if (stopThreadLock == null) {
            stopThreadLock = new AtomicBoolean(true);
        }
        stopThreadLock.set(true);
    }

    @Override
    public synchronized void start() {
        this.init();
    }

    @Override
    public void run() {
        stopThreadLock.set(false);
        long startWarplyInit = System.currentTimeMillis();
        int initAttempts = 0;
        while (!WarpUtils.isRegisteredWarply(this.mContext.getApplicationContext())) {
            if (stopThreadLock.get()) {
                return;
            }
            if (System.currentTimeMillis() - startWarplyInit > 20000L) {
                this.mInitCallback.onInit(this.mContext);
                startWarplyInit = System.currentTimeMillis();
                ++initAttempts;
            }
            if ((long)initAttempts < 3L) continue;
            this.notifyListener(true);
            return;
        }
        this.notifyListener(false);
    }

    private void notifyListener(final boolean timeOut) {
        if (this.mReadyCallback != null) {
            mMainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (timeOut) {
                        WarplyInitializer.this.mReadyCallback.onWarplyInitTimeOut();
                    } else {
                        WarplyInitializer.this.mReadyCallback.onWarplyReady();
                    }
                }
            });
        }
    }

    public synchronized void init() {
        block2: {
            stopThreadLock.set(true);
            this.mInitCallback.onInit(this.mContext);
            try {
                super.start();
            }
            catch (IllegalThreadStateException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public synchronized void initWithPermissions(Activity activity) {
        this.mContext = activity;
        PermissionsUtil permUtil = new PermissionsUtil((Context)activity, new PermissionsUtil.PermissionCallback(){

            @Override
            public void onPermissionDenied(List<PermissionDeniedResponse> denied) {
                WarplyInitializer.this.mPermissionsResultRequested = true;
                if (WarplyInitializer.this.mReadyCallback != null) {
                    WarplyInitializer.this.mReadyCallback.onWarplyPermissionsDenied();
                }
            }

            @Override
            public void onPermissionsGranted() {
                WarplyInitializer.this.mPermissionsResultRequested = true;
            }

            @Override
            public void onError(DexterError error) {
                this.onPermissionDenied(null);
            }
        }, null);
        if (permUtil.requestNeeded() && !this.mPermissionsResultRequested) {
            permUtil.requestPermissions();
        } else {
            this.mPermissionsResultRequested = true;
            this.init();
        }
    }

    public static interface WarplyInitCallback {
        public void onInit(Context var1);
    }
}

