/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.appcompat.app.AlertDialog;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ly.warp.sdk.R;
import ly.warp.sdk.Warply;
import ly.warp.sdk.activities.ContextualActivity;
import ly.warp.sdk.activities.CouponsetInfoActivity;
import ly.warp.sdk.activities.TelcoActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.ActiveBoxCouponModel;
import ly.warp.sdk.io.models.ActiveDFYCouponModel;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.CouponsetsList;
import ly.warp.sdk.io.models.CustomerStateModel;
import ly.warp.sdk.io.models.LoyaltyBadgeModel;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltyGiftsForYouPackage;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.MerchantList;
import ly.warp.sdk.io.models.PushCampaign;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.CosmoteRetrieveSharingRequest;
import ly.warp.sdk.io.request.CosmoteSharingRequest;
import ly.warp.sdk.io.request.WarplyIntegrationRequest;
import ly.warp.sdk.services.EventService;
import ly.warp.sdk.services.FCMBaseMessagingService;
import ly.warp.sdk.services.VouchersFetchedService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyManagerHelper {
    private static Consumer mConsumer = new Consumer();
    private static Consumer mConsumerInternal = new Consumer();
    private static HashMap<String, CampaignList> mUniqueCampaignList = new HashMap();
    private static CouponList mCouponList = new CouponList();
    private static CouponList mCouponRedeemedList = new CouponList();
    private static CouponList mCouponListExpired = new CouponList();
    private static CouponsetsList mCouponsetsList = new CouponsetsList();
    private static CouponsetsList mCouponsetsDealsList = new CouponsetsList();
    private static CustomerStateModel mCustomerStateModel = new CustomerStateModel();
    private static ArrayList<Campaign> mCampaignList = new ArrayList();
    private static ArrayList<Campaign> mCampaignListAll = new ArrayList();
    private static ArrayList<Campaign> mCarouselList = new ArrayList();
    private static ArrayList<ActiveDFYCouponModel> mDfyCoupons = new ArrayList();
    private static ArrayList<ActiveBoxCouponModel> mBoxCoupons = new ArrayList();
    private static ArrayList<LoyaltyGiftsForYouPackage> mSeasonalList = new ArrayList();
    private static ArrayList<LoyaltyContextualOfferModel> mCCMSList = new ArrayList();
    private static AlertDialog mAlertDialogSharing;
    private static AlertDialog mAlertDialogAcceptSharing;
    private static AlertDialog mAlertDialogRejectSharing;
    private static AlertDialog mAlertDialogReturnSharing;
    private static AlertDialog mAlertDialogErrorSharing;
    private static AlertDialog mAlertDialogErrorUsedSharing;
    private static AlertDialog mAlertDialogErrorExpiredSharing;
    private static AlertDialog mAlertDialogNoInternet;
    private static LoyaltyBadgeModel mLoyaltyBadge;
    private static float mDealsSum;
    private static float mUnifiedDiscount;
    private static float mBoxSum;
    private static MerchantList mMerchantList;
    public static double mMetersWebview;
    public static int mStepsWebview;
    public static int mSteps;
    private static ArrayList<UnifiedCoupon> mMarketCoupons;
    private static ArrayList<UnifiedCoupon> mMarketCouponsList;
    private static String showVouchersBanner;

    public static String constructCampaignUrl(Campaign item) {
        WarplyManager.getSingleCampaign(item.getSessionUUID());
        String url = item.getIndexUrl();
        JSONObject params = new JSONObject();
        try {
            params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
            params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
            params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
            params.putOpt("session_uuid", (Object)item.getSessionUUID());
            params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
            params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
            params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
            params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
        return url;
    }

    private static String constructCampaignUrl(Campaign item, String dlParam) {
        WarplyManager.getSingleCampaign(item.getSessionUUID());
        String url = item.getIndexUrl();
        JSONObject params = new JSONObject();
        try {
            params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
            params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
            params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
            params.putOpt("session_uuid", (Object)item.getSessionUUID());
            params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
            params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
            params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
            params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
            params.putOpt("dl_param", (Object)dlParam);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
        return url;
    }

    public static String constructCampaignUrl(Campaign item, boolean fromWidget) {
        item.setNew(false);
        String url = item.getIndexUrl();
        JSONObject params = new JSONObject();
        try {
            params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
            params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
            params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
            params.putOpt("session_uuid", (Object)item.getSessionUUID());
            params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
            params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
            params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
            params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
            params.putOpt("from_widget", (Object)fromWidget);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
        return url;
    }

    public static void handleSharing(final Activity context, final String sharingId) {
        WarpUtils.log("SHARING_ID: " + sharingId);
        WarplyManager.cosmoteSharing(new CosmoteSharingRequest().setSharingId(sharingId), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    JSONObject innerResult = new JSONObject();
                    innerResult = result.optJSONObject("result");
                    if (innerResult != null) {
                        String modalText = innerResult.optString("modal_text", "");
                        String sharingStatus = innerResult.optString("status", "");
                        String couponsetType = innerResult.optString("couponset_type", "");
                        if (!TextUtils.isEmpty((CharSequence)sharingStatus) && sharingStatus.equals("pending")) {
                            WarplyManagerHelper.initialSharingDialog(context, modalText, sharingId, !TextUtils.isEmpty((CharSequence)couponsetType) && couponsetType.equals("supermarket"));
                            return;
                        }
                        if (!TextUtils.isEmpty((CharSequence)sharingStatus) && sharingStatus.equals("reject")) {
                            WarplyManagerHelper.returnSharingDialog(context, modalText);
                        }
                    }
                } else if (status == 4) {
                    String modalText4 = result.optString("msg", "");
                    WarplyManagerHelper.errorExpiredDialog(context, modalText4);
                } else if (status == 5) {
                    String modalText5 = result.optString("msg", "");
                    WarplyManagerHelper.errorUsedDialog(context, modalText5);
                } else if (status == 7) {
                    String modalText7 = result.optString("msg", "");
                    WarplyManagerHelper.returnDialog(context, modalText7, sharingId);
                } else {
                    WarplyManagerHelper.errorSharingDialog(context);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                WarplyManagerHelper.errorSharingDialog(context);
            }
        });
    }

    private static void initialSharingDialog(final Activity context, String alertTitle, String sharingId, final boolean isSupermarket) {
        if (!context.isFinishing()) {
            mAlertDialogSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_success_title).setMessage((CharSequence)alertTitle).setNegativeButton(R.string.cos_dlg_negative_button, (dialogPositive, whichPositive) -> WarplyManagerHelper.rejectSharingDialog(context, sharingId)).setPositiveButton(R.string.cos_dlg_positive_button, (dialogNegative, whichNegative) -> WarplyManager.cosmoteRetrieveSharing(new CosmoteRetrieveSharingRequest().setSharingId(sharingId).setAccept(true), new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    int status = result.optInt("status", 2);
                    if (status == 1) {
                        WarplyManager.getUserCouponsWithCouponsets(new CallbackReceiver<CouponList>(){

                            @Override
                            public void onSuccess(CouponList result) {
                                WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
                                couponsChanged.setChanged(true);
                                EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
                            }

                            @Override
                            public void onFailure(int errorCode) {
                            }
                        });
                        WarplyManagerHelper.acceptSharingDialog(context, isSupermarket);
                    } else {
                        WarplyManagerHelper.errorSharingDialog(context);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    WarplyManagerHelper.errorSharingDialog(context);
                }
            })).show();
        }
    }

    private static void acceptSharingDialog(Activity context, boolean isSupermarket) {
        if (!context.isFinishing()) {
            mAlertDialogAcceptSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_success_title).setMessage(isSupermarket ? R.string.cos_dlg_positive_button_text2 : R.string.cos_dlg_positive_button_text).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private static void rejectSharingDialog(final Activity context, String sharingId) {
        if (!context.isFinishing()) {
            mAlertDialogRejectSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_reject_title).setMessage(R.string.cos_dlg_reject_text).setPositiveButton(R.string.cos_dlg_negative_button, (dialogPositive, whichPositive) -> WarplyManager.cosmoteRetrieveSharing(new CosmoteRetrieveSharingRequest().setSharingId(sharingId).setAccept(false), new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    int status = result.optInt("status", 2);
                    if (status == 1) {
                        WarplyManagerHelper.returnSharingSuccessDialog(context);
                    } else {
                        WarplyManagerHelper.errorSharingDialog(context);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    WarplyManagerHelper.errorSharingDialog(context);
                }
            })).setNegativeButton(R.string.cos_dlg_negative_button2, (dialogNegative, whichNegative) -> dialogNegative.dismiss()).show();
        }
    }

    private static void returnSharingDialog(Activity context, String alertTitle) {
        if (!context.isFinishing()) {
            mAlertDialogReturnSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cod_dlg_return_title).setMessage((CharSequence)alertTitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private static void returnSharingSuccessDialog(Activity context) {
        if (!context.isFinishing()) {
            mAlertDialogReturnSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cod_dlg_reject_title).setMessage(R.string.cod_dlg_reject_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private static void errorSharingDialog(Activity context) {
        if (!context.isFinishing()) {
            mAlertDialogErrorSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_error_title).setMessage(R.string.cos_dlg_error_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private static void returnDialog(final Activity context, String message, String sharingId) {
        if (!context.isFinishing()) {
            mAlertDialogErrorSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_return_title).setMessage((CharSequence)message).setNegativeButton(R.string.cos_dlg_negative_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).setPositiveButton(R.string.cos_dlg_positive_button, (dialogNegative, whichNegative) -> WarplyManager.cosmoteRetrieveSharing(new CosmoteRetrieveSharingRequest().setSharingId(sharingId).setAccept(true), new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    int status = result.optInt("status", 2);
                    if (status == 1) {
                        WarplyManager.getUserCouponsWithCouponsets(new CallbackReceiver<CouponList>(){

                            @Override
                            public void onSuccess(CouponList result) {
                                WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
                                couponsChanged.setChanged(true);
                                EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
                            }

                            @Override
                            public void onFailure(int errorCode) {
                            }
                        });
                    } else {
                        WarplyManagerHelper.errorSharingDialog(context);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    WarplyManagerHelper.errorSharingDialog(context);
                }
            })).show();
        }
    }

    private static void errorExpiredDialog(Activity context, String message) {
        if (!context.isFinishing()) {
            mAlertDialogErrorExpiredSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_error_title).setMessage((CharSequence)message).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private static void errorUsedDialog(Activity context, String message) {
        if (!context.isFinishing()) {
            mAlertDialogErrorUsedSharing = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_error_title).setMessage((CharSequence)message).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    public static void noInternetDialog(Activity context) {
        if (!context.isFinishing()) {
            mAlertDialogNoInternet = new AlertDialog.Builder((Context)context).setTitle(R.string.cos_dlg_no_internet_title).setMessage(R.string.cos_dlg_no_internet_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    public static boolean noInternetDialog(Context context, boolean check) {
        boolean[] hasInternetConnection = new boolean[]{true};
        if (WarplyDeviceInfoCollector.isNetworkAvailable(context)) {
            WarplyDeviceInfoCollector.hasInternetConnection().subscribe(hasInternet -> {
                if (!hasInternet.booleanValue()) {
                    hasInternetConnection[0] = false;
                }
            });
        } else {
            hasInternetConnection[0] = false;
        }
        return hasInternetConnection[0];
    }

    public static String constructCcmsUrl(Campaign item, LoyaltyContextualOfferModel ccmsItem) {
        WarplyManager.getSingleCampaign(item.getSessionUUID());
        Log.v((String)"CCMS_PRESSED", (String)(ccmsItem.getId() + " " + ccmsItem.getOfferName()));
        item.setNew(false);
        String assets = "";
        if (ccmsItem.getEligibleAssets() != null && ccmsItem.getEligibleAssets().size() > 0) {
            for (String singleAsset : ccmsItem.getEligibleAssets()) {
                assets = assets + singleAsset + ",";
            }
            if (!TextUtils.isEmpty((CharSequence)assets)) {
                assets = assets.substring(0, assets.length() - 1);
            }
        }
        String url = item.getIndexUrl();
        JSONObject params = new JSONObject();
        try {
            params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
            params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
            params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
            params.putOpt("session_uuid", (Object)item.getSessionUUID());
            params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
            params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
            params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
            params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
            params.putOpt("Session_ID", (Object)ccmsItem.getSessionId());
            params.putOpt("businessService", (Object)ccmsItem.getBusinessService());
            params.putOpt("offerName", (Object)ccmsItem.getOfferName());
            params.putOpt("productType", (Object)ccmsItem.getProductType());
            params.putOpt("provDuration", (Object)ccmsItem.getProvDuration());
            params.putOpt("noOfRecurrance", (Object)ccmsItem.getNoOfRecurrance());
            params.putOpt("price", (Object)ccmsItem.getPrice());
            params.putOpt("discount", (Object)ccmsItem.getDiscount());
            params.putOpt("voiceCategory", (Object)ccmsItem.getVoiceCategory());
            params.putOpt("dataCategory", (Object)ccmsItem.getDataCategory());
            params.putOpt("minsValue", (Object)ccmsItem.getMinsValue());
            params.putOpt("dataValue", (Object)ccmsItem.getDataValue());
            params.putOpt("provStepValueMins", (Object)ccmsItem.getProvStepValueMins());
            params.putOpt("UACIOfferTrackingCode", (Object)ccmsItem.getUACIOfferTrackingCode());
            params.putOpt("OFFERCODE1", (Object)ccmsItem.getOfferCode1());
            params.putOpt("SCORE", (Object)ccmsItem.getScore());
            params.putOpt("WAVE", (Object)ccmsItem.getWave());
            params.putOpt("VALIDITY", (Object)ccmsItem.getValidity());
            params.putOpt("TREATMENT_CODE", (Object)ccmsItem.getTreatmentCode());
            params.putOpt("OfferAudienceLevel", (Object)ccmsItem.getOfferAudienceLevel());
            params.putOpt("ASSETS", (Object)assets);
            params.putOpt("ZONE", (Object)ccmsItem.getZone());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
        return url;
    }

    public static String constructCcmsUrl(LoyaltyContextualOfferModel item) {
        String url = "";
        if (item != null && mCampaignList != null && mCampaignList.size() > 0) {
            for (Campaign camp : mCampaignList) {
                try {
                    JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                    if (extraFields == null || !extraFields.has("ccms_offer") || !extraFields.optString("ccms_offer").equals("true") || !item.getLoyaltyCampaignId().equals(camp.getSessionUUID())) continue;
                    WarplyManager.getSingleCampaign(camp.getSessionUUID());
                    String assets = "";
                    if (item.getEligibleAssets() != null && item.getEligibleAssets().size() > 0) {
                        for (String singleAsset : item.getEligibleAssets()) {
                            assets = assets + singleAsset + ",";
                        }
                        if (!TextUtils.isEmpty((CharSequence)assets)) {
                            assets = assets.substring(0, assets.length() - 1);
                        }
                    }
                    url = camp.getIndexUrl();
                    JSONObject params = new JSONObject();
                    try {
                        params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
                        params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
                        params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
                        params.putOpt("session_uuid", (Object)camp.getSessionUUID());
                        params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
                        params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
                        params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
                        params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
                        params.putOpt("Session_ID", (Object)item.getSessionId());
                        params.putOpt("businessService", (Object)item.getBusinessService());
                        params.putOpt("offerName", (Object)item.getOfferName());
                        params.putOpt("productType", (Object)item.getProductType());
                        params.putOpt("provDuration", (Object)item.getProvDuration());
                        params.putOpt("noOfRecurrance", (Object)item.getNoOfRecurrance());
                        params.putOpt("price", (Object)item.getPrice());
                        params.putOpt("discount", (Object)item.getDiscount());
                        params.putOpt("voiceCategory", (Object)item.getVoiceCategory());
                        params.putOpt("dataCategory", (Object)item.getDataCategory());
                        params.putOpt("minsValue", (Object)item.getMinsValue());
                        params.putOpt("dataValue", (Object)item.getDataValue());
                        params.putOpt("provStepValueMins", (Object)item.getProvStepValueMins());
                        params.putOpt("UACIOfferTrackingCode", (Object)item.getUACIOfferTrackingCode());
                        params.putOpt("OFFERCODE1", (Object)item.getOfferCode1());
                        params.putOpt("SCORE", (Object)item.getScore());
                        params.putOpt("WAVE", (Object)item.getWave());
                        params.putOpt("VALIDITY", (Object)item.getValidity());
                        params.putOpt("TREATMENT_CODE", (Object)item.getTreatmentCode());
                        params.putOpt("OfferAudienceLevel", (Object)item.getOfferAudienceLevel());
                        params.putOpt("ASSETS", (Object)assets);
                        params.putOpt("ZONE", (Object)item.getZone());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
                    break;
                }
                catch (Exception exception) {
                    Log.v((String)"WarplyManagerHelper_CCMS_Error", (String)exception.toString());
                }
            }
        }
        return url;
    }

    public static void handleContextualCampaigns(Context context, LoyaltyContextualOfferModel item) {
        if (item != null) {
            if (TextUtils.isEmpty((CharSequence)item.getLoyaltyCampaignId()) || item.getLoyaltyCampaignId().equals("NA")) {
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                analyticsEvent.setParameter("name", item.getTitle());
                analyticsEvent.setParameter("type", "gift");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                WarplyAnalyticsManager.logTrackersEvent(context, "click", "Contextual".concat(":").concat(item.getSessionId()));
                Intent intent = new Intent(context, ContextualActivity.class);
                intent.putExtra("ccms", (Serializable)item);
                context.startActivity(intent);
            } else if (mCampaignListAll != null && mCampaignListAll.size() > 0) {
                for (Campaign camp : mCampaignListAll) {
                    try {
                        JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                        if (extraFields == null) continue;
                        if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                            if (!item.getLoyaltyCampaignId().equals(camp.getSessionUUID())) continue;
                            WarplyManager.getSingleCampaign(camp.getSessionUUID());
                            String assets = "";
                            if (item.getEligibleAssets() != null && item.getEligibleAssets().size() > 0) {
                                for (String singleAsset : item.getEligibleAssets()) {
                                    assets = assets + singleAsset + ",";
                                }
                                if (!TextUtils.isEmpty((CharSequence)assets)) {
                                    assets = assets.substring(0, assets.length() - 1);
                                }
                            }
                            String url = camp.getIndexUrl();
                            JSONObject params = new JSONObject();
                            try {
                                params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
                                params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
                                params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
                                params.putOpt("session_uuid", (Object)camp.getSessionUUID());
                                params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
                                params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
                                params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
                                params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
                                params.putOpt("Session_ID", (Object)item.getSessionId());
                                params.putOpt("businessService", (Object)item.getBusinessService());
                                params.putOpt("offerName", (Object)item.getOfferName());
                                params.putOpt("productType", (Object)item.getProductType());
                                params.putOpt("provDuration", (Object)item.getProvDuration());
                                params.putOpt("noOfRecurrance", (Object)item.getNoOfRecurrance());
                                params.putOpt("price", (Object)item.getPrice());
                                params.putOpt("discount", (Object)item.getDiscount());
                                params.putOpt("voiceCategory", (Object)item.getVoiceCategory());
                                params.putOpt("dataCategory", (Object)item.getDataCategory());
                                params.putOpt("minsValue", (Object)item.getMinsValue());
                                params.putOpt("dataValue", (Object)item.getDataValue());
                                params.putOpt("provStepValueMins", (Object)item.getProvStepValueMins());
                                params.putOpt("UACIOfferTrackingCode", (Object)item.getUACIOfferTrackingCode());
                                params.putOpt("OFFERCODE1", (Object)item.getOfferCode1());
                                params.putOpt("SCORE", (Object)item.getScore());
                                params.putOpt("WAVE", (Object)item.getWave());
                                params.putOpt("VALIDITY", (Object)item.getValidity());
                                params.putOpt("TREATMENT_CODE", (Object)item.getTreatmentCode());
                                params.putOpt("OfferAudienceLevel", (Object)item.getOfferAudienceLevel());
                                params.putOpt("ASSETS", (Object)assets);
                                params.putOpt("ZONE", (Object)item.getZone());
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            if (!WarplyManagerHelper.noInternetDialog(context, true)) {
                                WarplyManagerHelper.noInternetDialog((Activity)context);
                                return;
                            }
                            WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
                            WarplyAnalyticsManager.logTrackersEvent(context, "click", "Contextual".concat(":").concat(item.getSessionId()));
                            context.startActivity(WarpViewActivity.createIntentFromURL(context, url));
                            break;
                        }
                        if (!extraFields.has("type") || !extraFields.optString("type").equals("telco") || !item.getLoyaltyCampaignId().equals(camp.getSessionUUID())) continue;
                        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                        analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                        analyticsEvent.setParameter("name", item.getTitle());
                        analyticsEvent.setParameter("type", "gift");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        WarplyAnalyticsManager.logTrackersEvent(context, "click", "Telco".concat(":").concat(item.getSessionId()));
                        WarplyManager.getSingleCampaign(camp.getSessionUUID());
                        Intent intent = new Intent(context, TelcoActivity.class);
                        intent.putExtra("ccms", (Serializable)item);
                        intent.putExtra("loyalty", camp.getSessionUUID());
                        context.startActivity(intent);
                        break;
                    }
                    catch (Exception exception) {
                        Log.v((String)"handleContextual_Error", (String)exception.toString());
                    }
                }
            }
        }
    }

    public static void handleLoyaltyCampaigns(Context context, Campaign item) {
        if (item != null) {
            if (item.getType().equals("coupon")) {
                block17: {
                    if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
                        LoyaltyContextualOfferModel ccmsItem = null;
                        for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                            if (!ccms.getLoyaltyCampaignId().equals(item.getSessionUUID())) continue;
                            ccmsItem = ccms;
                            break;
                        }
                        if (ccmsItem != null) {
                            block16: {
                                try {
                                    JSONObject campaignSettings = WarpJSONParser.getJSONFromString(item.getCampaignTypeSettings());
                                    if (campaignSettings == null) break block16;
                                    if (campaignSettings.has("couponset")) {
                                        String cpnUuid = campaignSettings.optString("couponset");
                                        for (Couponset cpns : WarplyManagerHelper.getCouponsets()) {
                                            if (!cpns.getUuid().equals(cpnUuid)) continue;
                                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                            analyticsEvent.setParameter("name", item.getTitle());
                                            analyticsEvent.setParameter("type", "coupon");
                                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                                            WarplyAnalyticsManager.logTrackersEvent(context, "click", "Loyalty".concat(":").concat(item.getSessionUUID()));
                                            WarplyManager.getSingleCampaign(item.getSessionUUID());
                                            Intent intent = new Intent(context, CouponsetInfoActivity.class);
                                            intent.putExtra("couponset", cpns.getUuid());
                                            intent.putExtra("loyalty", item.getSessionUUID());
                                            intent.putExtra("ccms", (Serializable)ccmsItem);
                                            context.startActivity(intent);
                                            break block16;
                                        }
                                        break block16;
                                    }
                                    if (!WarplyManagerHelper.noInternetDialog(context, true)) {
                                        WarplyManagerHelper.noInternetDialog((Activity)context);
                                        return;
                                    }
                                    WarplyAnalyticsManager.logTrackersEvent(context, "click", "Loyalty".concat(":").concat(item.getSessionUUID()));
                                    context.startActivity(WarpViewActivity.createIntentFromURL(context, WarplyManagerHelper.constructCampaignUrl(item)));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            return;
                        }
                    }
                    try {
                        JSONObject campaignSettings = WarpJSONParser.getJSONFromString(item.getCampaignTypeSettings());
                        if (campaignSettings == null) break block17;
                        if (campaignSettings.has("couponset")) {
                            String cpnUuid = campaignSettings.optString("couponset");
                            for (Couponset cpns : WarplyManagerHelper.getCouponsets()) {
                                if (!cpns.getUuid().equals(cpnUuid)) continue;
                                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                analyticsEvent.setParameter("name", item.getTitle());
                                analyticsEvent.setParameter("type", "coupon");
                                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                                WarplyAnalyticsManager.logTrackersEvent(context, "click", "Loyalty".concat(":").concat(item.getSessionUUID()));
                                WarplyManager.getSingleCampaign(item.getSessionUUID());
                                Intent intent = new Intent(context, CouponsetInfoActivity.class);
                                intent.putExtra("couponset", cpns.getUuid());
                                intent.putExtra("loyalty", item.getSessionUUID());
                                context.startActivity(intent);
                                break block17;
                            }
                            break block17;
                        }
                        if (!WarplyManagerHelper.noInternetDialog(context, true)) {
                            WarplyManagerHelper.noInternetDialog((Activity)context);
                            return;
                        }
                        WarplyAnalyticsManager.logTrackersEvent(context, "click", "Loyalty".concat(":").concat(item.getSessionUUID()));
                        context.startActivity(WarpViewActivity.createIntentFromURL(context, WarplyManagerHelper.constructCampaignUrl(item)));
                    }
                    catch (Exception exception) {
                        Log.v((String)"handleLoyalty_Error", (String)exception.toString());
                    }
                }
                return;
            }
            if (!WarplyManagerHelper.noInternetDialog(context, true)) {
                WarplyManagerHelper.noInternetDialog((Activity)context);
                return;
            }
            WarplyAnalyticsManager.logTrackersEvent(context, "click", "Loyalty".concat(":").concat(item.getSessionUUID()));
            context.startActivity(WarpViewActivity.createIntentFromURL(context, WarplyManagerHelper.constructCampaignUrl(item)));
        }
    }

    public static void setCCMSLoyaltyCampaigns(ArrayList<LoyaltyContextualOfferModel> list) {
        mCCMSList.clear();
        mCCMSList = list;
        OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventService.class).build();
        WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
    }

    public static void clearCCMSLoyaltyCampaigns() {
        mCCMSList.clear();
        OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventService.class).build();
        WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
    }

    public static ArrayList<LoyaltyContextualOfferModel> getCCMSLoyaltyCampaigns() {
        return mCCMSList;
    }

    public static void setSeasonalList(ArrayList<LoyaltyGiftsForYouPackage> seasonalCoupons) {
        mSeasonalList.clear();
        mSeasonalList = seasonalCoupons;
    }

    public static ArrayList<LoyaltyGiftsForYouPackage> getSeasonalList() {
        return mSeasonalList;
    }

    public static String openQuestionnaire() {
        if (mCampaignListAll != null && mCampaignListAll.size() > 0) {
            for (Campaign camp : mCampaignListAll) {
                if (!camp.getOfferCategory().equals("questionnaire")) continue;
                return WarplyManagerHelper.constructCampaignUrl(camp);
            }
        }
        return "";
    }

    public static void handleSMDealsCampaign(Context context, String dlParam) {
        if (!WarplyManagerHelper.noInternetDialog(context, true)) {
            WarplyManagerHelper.noInternetDialog((Activity)context);
            return;
        }
        if (mCampaignListAll != null && mCampaignListAll.size() > 0) {
            for (Campaign camp : mCampaignListAll) {
                if (!camp.getSessionUUID().equals("39e70f0548884020809dda5f78d06c85") && !camp.getSessionUUID().equals("8314046c83a44576a03ccc3cd9e825db")) continue;
                context.startActivity(WarpViewActivity.createIntentFromURL(context, WarplyManagerHelper.constructCampaignUrl(camp, dlParam)));
                break;
            }
        }
    }

    public static String openPacing() {
        if (mCampaignListAll != null && mCampaignListAll.size() > 0) {
            for (Campaign camp : mCampaignListAll) {
                if (!camp.getOfferCategory().equals("pacing")) continue;
                String pacingUrl = WarplyManagerHelper.constructCampaignUrl(camp, true);
                WarpUtils.log("PACING_LOG: " + pacingUrl);
                return pacingUrl;
            }
        }
        return "";
    }

    public static void openCouponset(Context context, Campaign item) {
        block3: {
            try {
                JSONObject campaignSettings = WarpJSONParser.getJSONFromString(item.getCampaignTypeSettings());
                if (campaignSettings == null || !campaignSettings.has("couponset")) break block3;
                String cpnUuid = campaignSettings.optString("couponset");
                for (Couponset cpns : mCouponsetsList) {
                    if (!cpns.getUuid().equals(cpnUuid)) continue;
                    Intent intent = new Intent(context, CouponsetInfoActivity.class);
                    intent.putExtra("couponset", cpns.getUuid());
                    intent.putExtra("loyalty", item.getSessionUUID());
                    context.startActivity(intent);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void openTelco(Context context, Campaign item) {
        for (LoyaltyContextualOfferModel ccms : mCCMSList) {
            if (!ccms.getLoyaltyCampaignId().equals(item.getSessionUUID())) continue;
            Intent intent = new Intent(context, TelcoActivity.class);
            intent.putExtra("ccms", (Serializable)ccms);
            intent.putExtra("loyalty", item.getSessionUUID());
            context.startActivity(intent);
            break;
        }
    }

    public static void saveCustomerState(CustomerStateModel customerState) {
        mCustomerStateModel = customerState;
        WarpUtils.setLanguage(Warply.getWarplyContext(), customerState.getLanguage());
        WarplyIntegrationRequest request = new WarplyIntegrationRequest();
        request.setIsNoTelco(customerState.isNonTelco()).setHasAcceptedConsent(customerState.isAcceptedConsent()).setGuid(customerState.getGuid()).setMsisdnList(customerState.getMsisdnList()).setLanguage(customerState.getLanguage());
        WarplyManager.consumerIntegration(request, new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                WarpUtils.log("CUSTOMER STATE SUCCESS");
            }

            @Override
            public void onFailure(int errorCode) {
                WarpUtils.log("CUSTOMER STATE ERROR");
            }
        });
    }

    public static void setTrackersEnabled(Context context, boolean isEnabled) {
        WarpUtils.setTrackersEnabled(context, isEnabled);
    }

    public static CustomerStateModel loadCustomerState() {
        return mCustomerStateModel;
    }

    public static String getUserTag(Context context) {
        return WarpUtils.getUserTag(context);
    }

    public static void setActiveDFYCoupons(ArrayList<ActiveDFYCouponModel> dfyCoupons) {
        mDfyCoupons.clear();
        mDfyCoupons = dfyCoupons;
    }

    public static ArrayList<ActiveDFYCouponModel> getActiveDFYCoupons() {
        return mDfyCoupons;
    }

    public static void setActiveBoxCoupons(ArrayList<ActiveBoxCouponModel> boxCoupons) {
        mBoxCoupons.clear();
        mBoxCoupons = boxCoupons;
    }

    public static ArrayList<ActiveBoxCouponModel> getActiveBoxCoupons() {
        return mBoxCoupons;
    }

    public static Consumer getConsumerInternal() {
        return mConsumerInternal;
    }

    public static void setConsumerInternal(Consumer consumer) {
        mConsumerInternal = consumer;
    }

    public static Consumer getConsumer() {
        return mConsumer;
    }

    public static void setConsumer(Consumer consumer) {
        mConsumer = consumer;
    }

    public static HashMap<String, CampaignList> getUniqueCampaignList() {
        return mUniqueCampaignList;
    }

    public static CouponList getCouponList() {
        if (mCouponList != null && mCouponList.size() > 0) {
            WarpUtils.log("GET_COUPON_LIST size: " + String.valueOf(mCouponList.size()));
        } else {
            WarpUtils.log("GET_COUPON_LIST size: 0");
        }
        return mCouponList;
    }

    public static CouponList getCouponExpiredList() {
        if (mCouponListExpired != null && mCouponListExpired.size() > 0) {
            WarpUtils.log("GET_COUPON_EXPIRED_LIST size: " + String.valueOf(mCouponListExpired.size()));
        } else {
            WarpUtils.log("GET_COUPON_EXPIRED_LIST size: 0");
        }
        return mCouponListExpired;
    }

    public static void setUniqueCampaignList(ArrayList<Campaign> campaignList) {
        mCampaignList.clear();
        mCampaignList.addAll(campaignList);
    }

    public static void setCampaignList(ArrayList<Campaign> campaignList) {
        mCampaignListAll.clear();
        mCampaignListAll = campaignList;
        mCampaignList.clear();
        for (Campaign camp : campaignList) {
            try {
                JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                if (extraFields == null || extraFields.length() != 0 && (extraFields.has("ccms_offer") || extraFields.has("type"))) continue;
                mCampaignList.add(camp);
            }
            catch (Exception exception) {
                mCampaignList.add(camp);
            }
        }
    }

    public static void setCarouselList(ArrayList<Campaign> carouselList) {
        WarpUtils.log("SET_CAROUSEL_LIST_PARAM_COUNT: " + String.valueOf(carouselList.size()));
        WarpUtils.log("SET_CAROUSEL_LIST_PARAM_JSON: " + String.valueOf(carouselList.toString()));
        mCarouselList.clear();
        mCarouselList.addAll(carouselList);
        WarpUtils.log("SET_CAROUSEL_LIST_VAR_COUNT: " + String.valueOf(mCarouselList.size()));
        WarpUtils.log("SET_CAROUSEL_LIST_VAR_JSON: " + String.valueOf(mCarouselList.toString()));
    }

    public static ArrayList<Campaign> getCarouselList() {
        return mCarouselList;
    }

    public static ArrayList<Campaign> getCampaignList() {
        return mCampaignList;
    }

    public static ArrayList<Campaign> getCampaignListAll() {
        return mCampaignListAll;
    }

    public static void setCouponList(CouponList couponList) {
        LoyaltyBadgeModel badge = new LoyaltyBadgeModel();
        CouponList cpnlist = new CouponList();
        CouponList cpnlistExpired = new CouponList();
        float couponValue = 0.0f;
        int couponCount = 0;
        for (Coupon coupon : couponList) {
            if (coupon.getStatus() == 1) {
                cpnlist.add(coupon);
                continue;
            }
            if (coupon.getStatus() != 0) continue;
            cpnlistExpired.add(coupon);
            try {
                ++couponCount;
                couponValue += (float)coupon.getCouponsetDetails().getFinal_price();
            }
            catch (NumberFormatException e) {
                --couponCount;
            }
        }
        badge.setCouponCount(couponCount);
        badge.setValue(couponValue);
        mLoyaltyBadge = badge;
        mCouponList.clear();
        mCouponList.addAll(cpnlist);
        ExecutorService executorShops = Executors.newFixedThreadPool(1);
        executorShops.submit(() -> {
            mCouponListExpired.clear();
            Collections.sort(cpnlistExpired, (coupon1, coupon2) -> coupon2.getRedeemDate().compareTo(coupon1.getRedeemDate()));
            mCouponListExpired.addAll(cpnlistExpired);
            executorShops.shutdownNow();
        });
    }

    public static void setCouponRedeemedList(CouponList couponRedeemedList) {
        mCouponRedeemedList.clear();
        mCouponRedeemedList.addAll(couponRedeemedList);
    }

    public static CouponList getCouponRedeemedList() {
        return mCouponRedeemedList;
    }

    public static LoyaltyBadgeModel getLoyaltyBadge() {
        return mLoyaltyBadge;
    }

    public static CouponsetsList getCouponsets() {
        return mCouponsetsList;
    }

    public static void setCouponsets(CouponsetsList couponsets) {
        mCouponsetsList = couponsets;
    }

    public static void setCouponsetsDeals(CouponsetsList couponsetsDeals) {
        mCouponsetsDealsList = couponsetsDeals;
    }

    public static CouponsetsList getCouponsetsDeals() {
        return mCouponsetsDealsList;
    }

    public static void setMerchantList(MerchantList merchantList) {
        mMerchantList.clear();
        mMerchantList = merchantList;
    }

    public static MerchantList getMerchantList() {
        return mMerchantList;
    }

    public static float getDealsCouponsSum() {
        return mDealsSum;
    }

    public static void setDealsCouponsSum(float sum) {
        mDealsSum = sum;
    }

    public static float getBoxCouponsSum() {
        return mBoxSum;
    }

    public static void setBoxCouponsSum(float sum) {
        mBoxSum = sum;
    }

    public static ArrayList<UnifiedCoupon> getMarketCoupons() {
        return mMarketCoupons;
    }

    public static void setMarketCoupons(ArrayList<UnifiedCoupon> marketCoupons) {
        mMarketCoupons = marketCoupons;
    }

    public static ArrayList<UnifiedCoupon> getMarketCouponsList() {
        return mMarketCouponsList;
    }

    public static void setMarketCouponsList(ArrayList<UnifiedCoupon> marketCoupons) {
        mMarketCouponsList = marketCoupons;
    }

    public static void setUnifiedCouponsDiscount(float unifiedDiscount) {
        mUnifiedDiscount = unifiedDiscount;
    }

    public static float getUnifiedCouponsDiscount() {
        return mUnifiedDiscount;
    }

    public static boolean checkForLoyaltySDKNotification(Context context, Map<String, String> pushPayload) {
        Bundle data = WarplyManagerHelper.convertToBundle(pushPayload);
        if (data == null || !data.containsKey("loyalty-action")) {
            return false;
        }
        PushCampaign pc = new PushCampaign(data);
        WarpUtils.log("Received push with action: " + pc.getAction());
        if (pc.getAction() == 0 && !pc.hasActions()) {
            FCMBaseMessagingService.showCampaignNotification(context, pc);
        } else {
            WarplyManagerHelper.showDefaultNotification(context, data);
        }
        return true;
    }

    private static Bundle convertToBundle(Map<String, String> data) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    private static void showDefaultNotification(Context context, Bundle data) {
        PushCampaign pc = new PushCampaign(data);
        if (pc != null) {
            PackageManager pm = context.getPackageManager();
            Intent newIntent = pm.getLaunchIntentForPackage(context.getPackageName());
            FCMBaseMessagingService.showNotification(context, pc, newIntent, null, null, null, 0);
        }
    }

    public static void logoutUser() {
    }

    private static boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)Warply.getWarplyContext().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void clearShowVouchersBanner() {
        showVouchersBanner = "";
    }

    public static void setShowVouchersBanner(String show) {
        showVouchersBanner = show;
    }

    public static String getShowVouchersBanner() {
        return showVouchersBanner;
    }

    public static void setVouchersFetched(String success) {
        if (success.equals("true") || success.equals("false") || success.equals("null")) {
            WarplyManagerHelper.setShowVouchersBanner(success);
        } else {
            WarplyManagerHelper.setShowVouchersBanner("null");
        }
        OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(VouchersFetchedService.class).build();
        WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
    }

    static {
        mLoyaltyBadge = new LoyaltyBadgeModel();
        mDealsSum = 0.0f;
        mUnifiedDiscount = 0.0f;
        mBoxSum = 0.0f;
        mMerchantList = new MerchantList();
        mMetersWebview = 0.0;
        mStepsWebview = 0;
        mSteps = 0;
        mMarketCoupons = new ArrayList();
        mMarketCouponsList = new ArrayList();
        showVouchersBanner = "";
    }
}

