/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import java.util.Map;
import java.util.Set;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyPreferences {
    private static final String WARPLY_SHARED_PREFS = "ly.warp.sdk.preferences";
    private SharedPreferences warplySharedPrefs;

    public WarplyPreferences(Context context) {
        try {
            SharedPreferences encryptedSharedPreferences;
            MasterKey masterKey = new MasterKey.Builder(context, "_androidx_security_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
            this.warplySharedPrefs = encryptedSharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)WARPLY_SHARED_PREFS, (MasterKey)masterKey, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        }
        catch (Exception e) {
            WarpUtils.log("WarplyPreferences Encrypted Shared Preferences Error", e);
            this.warplySharedPrefs = context.getSharedPreferences(WARPLY_SHARED_PREFS, 0);
        }
    }

    public void saveLocationChangedReceiverStatus(String status) {
        this.warplySharedPrefs.edit().putString("locChangedReceiverStatus", status).apply();
    }

    public String getLocationChangedReceiverStatus() {
        return this.warplySharedPrefs.getString("locChangedReceiverStatus", "off");
    }

    public void saveUpdateLocationServiceStatus(String status) {
        this.warplySharedPrefs.edit().putString("updateLocServiceStatus", status).apply();
    }

    public String getUpdateLocationServiceStatus() {
        return this.warplySharedPrefs.getString("updateLocServiceStatus", "off");
    }

    public void saveAppStatus(String appStatus) {
        this.warplySharedPrefs.edit().putString("appStatus", appStatus).apply();
    }

    public String getAppStatus() {
        return this.warplySharedPrefs.getString("appStatus", "background");
    }

    public boolean isForeground() {
        return !this.getAppStatus().equals("background");
    }

    public void saveConsumerAppStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("consumerApp", microAppStatus).apply();
    }

    public boolean getConsumerAppStatus() {
        return this.warplySharedPrefs.getBoolean("consumerApp", true);
    }

    public void saveAppDataStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("appData", microAppStatus).apply();
    }

    public boolean getAppDataStatus() {
        return this.warplySharedPrefs.getBoolean("appData", true);
    }

    public void saveOffersStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("offers", microAppStatus).apply();
    }

    public boolean getOffersStatus() {
        return this.warplySharedPrefs.getBoolean("offers", true);
    }

    public void saveLifeCycleAnalyticsStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("life_cycle_analytics", microAppStatus).apply();
    }

    public boolean getLifeCycleAnalyticsStatus() {
        return this.warplySharedPrefs.getBoolean("life_cycle_analytics", true);
    }

    public void saveCustomAnalyticsStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("custom_analytics", microAppStatus).apply();
    }

    public boolean getCustomAnalyticsStatus() {
        return this.warplySharedPrefs.getBoolean("custom_analytics", true);
    }

    public void saveUserTaggingStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("userTagging", microAppStatus).apply();
    }

    public boolean getUserTaggingStatus() {
        return this.warplySharedPrefs.getBoolean("userTagging", true);
    }

    public void saveDeviceInfoStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("deviceInfo", microAppStatus).apply();
    }

    public boolean getDeviceInfoStatus() {
        return this.warplySharedPrefs.getBoolean("deviceInfo", true);
    }

    public void saveUserSessionStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("userSession", microAppStatus).apply();
    }

    public boolean getUserSessionStatus() {
        return this.warplySharedPrefs.getBoolean("userSession", true);
    }

    public void saveBeaconsStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("beacons", microAppStatus).apply();
    }

    public boolean getBeaconsStatus() {
        return this.warplySharedPrefs.getBoolean("beacons", true);
    }

    public void saveRadioSilentStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("radioSilent", microAppStatus).apply();
    }

    public boolean getRadioSilentStatus() {
        return this.warplySharedPrefs.getBoolean("radioSilent", false);
    }

    public void saveGeofencingStatus(boolean microAppStatus) {
        this.warplySharedPrefs.edit().putBoolean("geofencing", microAppStatus).apply();
    }

    public boolean getGeofencingStatus() {
        return this.warplySharedPrefs.getBoolean("geofencing", true);
    }

    public void saveInboxLastCachedTimeStamp(String requestSignature, long timeStamp) {
        this.warplySharedPrefs.edit().putLong("inbox_time_stamp_" + requestSignature, timeStamp).apply();
    }

    public long getInboxLastCachedTimeStamp(String requestSignature) {
        return this.warplySharedPrefs.getLong("inbox_time_stamp_" + requestSignature, 0L);
    }

    public void clearInboxLastCachedTimeStamps() {
        SharedPreferences.Editor editor = this.warplySharedPrefs.edit();
        Map mapPref = this.warplySharedPrefs.getAll();
        Set keys = mapPref.keySet();
        for (String key : keys) {
            if (!key.contains("inbox_time_stamp")) continue;
            editor.putLong(key, 0L);
        }
        editor.apply();
    }

    public void saveInt(String key, int value) {
        this.warplySharedPrefs.edit().putInt(key, value).apply();
    }

    public int getInt(String key, int defaultValue) {
        return this.warplySharedPrefs.getInt(key, defaultValue);
    }

    public void saveBoolean(String key, boolean value) {
        this.warplySharedPrefs.edit().putBoolean(key, value).apply();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.warplySharedPrefs.getBoolean(key, defaultValue);
    }

    public void saveLong(String key, long value) {
        this.warplySharedPrefs.edit().putLong(key, value).apply();
    }

    public long getLong(String key, long defaultValue) {
        return this.warplySharedPrefs.getLong(key, defaultValue);
    }

    public void saveString(String key, String value) {
        this.warplySharedPrefs.edit().putString(key, value).apply();
    }

    public String getString(String key, String defaultValue) {
        return this.warplySharedPrefs.getString(key, defaultValue);
    }

    public void saveStringArray(String key, String[] value) {
        block4: {
            try {
                if (value != null && value.length > 0) {
                    JSONArray arrayJson = new JSONArray();
                    for (int i = 0; i < value.length; ++i) {
                        arrayJson.put((Object)value[i]);
                    }
                    JSONObject json = new JSONObject();
                    json.put(key, (Object)arrayJson);
                    this.warplySharedPrefs.edit().putString(key, json.toString()).apply();
                }
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        String[] value;
        block5: {
            value = defaultValue;
            String jsonStr = this.warplySharedPrefs.getString(key, null);
            if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
                try {
                    JSONObject json = new JSONObject(jsonStr);
                    JSONArray jsonArray = json.optJSONArray(key);
                    if (jsonArray != null && jsonArray.length() > 0) {
                        value = new String[jsonArray.length()];
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            value[i] = jsonArray.optString(i);
                        }
                    }
                }
                catch (JSONException e) {
                    if (!WarpConstants.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        return value;
    }
}

