/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.TypedValue;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import java.io.IOException;
import java.util.Properties;
import ly.warp.sdk.R;
import ly.warp.sdk.utils.WarpUtils;

public class WarplyProperty {
    public static final String PROPERTIES_FILE = "warply.properties";
    public static final String KEY_UUID = "Uuid";
    public static final String KEY_DEBUG = "Debug";
    public static final String KEY_SEND_PACKAGES = "SendPackages";
    public static final String KEY_WEB_ACTION_HANDLER = "WebActionHandler";
    public static final String KEY_PROGRESS_COLOR = "ProgressColor";
    public static final String KEY_PROGRESS_DRAWABLE = "ProgressDrawable";
    public static final String KEY_PUSH_COLOR = "PushColor";
    public static final String KEY_PUSH_ICON = "PushIcon";
    public static final String KEY_PUSH_SOUND = "PushSound";
    public static final String KEY_LANGUAGE = "Language";
    public static final String KEY_MERCHANT_ID = "MerchantId";
    public static final String KEY_LOGIN_TYPE = "LoginType";
    public static final String KEY_DL_URL_SCHEME = "DL_URL_SCHEME";
    public static final String KEY_BASE_URL = "BaseURL";
    public static final String KEY_VERIFY_URL = "VerifyURL";

    private static String getWarplyProperty(Context context, String propertyKey) {
        if (context == null) {
            return "";
        }
        try {
            Properties properties = new Properties();
            properties.load(context.getResources().getAssets().open(PROPERTIES_FILE));
            return properties.getProperty(propertyKey);
        }
        catch (IOException | NullPointerException e) {
            WarpUtils.log(e.getMessage());
            return "";
        }
    }

    @Nullable
    private static Bundle getMetaData(Context context) {
        try {
            return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            WarpUtils.log("Metadata fail", (Exception)((Object)e));
            return null;
        }
    }

    private static String getStringMetadata(Context context, String key) {
        Bundle data = WarplyProperty.getMetaData(context);
        return data != null ? data.getString(key) : "";
    }

    private static boolean getBooleanMetadata(Context context, String key, boolean defValue) {
        Bundle data = WarplyProperty.getMetaData(context);
        return data != null ? data.getBoolean(key, defValue) : defValue;
    }

    private static int getIntMetadata(Context context, String key, int defValue) {
        Bundle data = WarplyProperty.getMetaData(context);
        return data != null ? data.getInt(key, defValue) : defValue;
    }

    @NonNull
    private static Drawable getLauncherIcon(Context context, Drawable defaultDrawable) {
        try {
            int iconRes = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).icon;
            return ContextCompat.getDrawable((Context)context, (int)iconRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            WarpUtils.log("Metadata fail", (Exception)((Object)e));
            return defaultDrawable;
        }
    }

    private static int getPrimaryColor(Context context, int defValue) {
        try {
            TypedValue typedValue = new TypedValue();
            TypedArray typedArray = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
            int color2 = typedArray.getColor(0, defValue);
            typedArray.recycle();
            return color2;
        }
        catch (UnsupportedOperationException e) {
            WarpUtils.log(e.getMessage());
            return defValue;
        }
    }

    public static int getAppVersionCode(Context context) {
        PackageInfo packInfo = null;
        try {
            packInfo = context.getApplicationContext().getPackageManager().getPackageInfo(context.getApplicationContext().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            WarpUtils.log(e.getMessage());
        }
        return packInfo != null ? packInfo.versionCode : 0;
    }

    public static boolean isInDevelopmentMode(Context context) {
        boolean debuggable = false;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(context.getPackageName(), 0);
            debuggable = 0 != (appInfo.flags &= 2);
        }
        catch (PackageManager.NameNotFoundException e) {
            WarpUtils.log(e.getMessage());
        }
        return debuggable;
    }

    public static String getCustomPushServiceClassName(Context context) {
        String name;
        block3: {
            name = null;
            try {
                PackageInfo packInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4);
                if (packInfo == null || packInfo.services == null || packInfo.services.length <= 0) break block3;
                for (ServiceInfo sInfo : packInfo.services) {
                    if (TextUtils.isEmpty((CharSequence)sInfo.nonLocalizedLabel) || !"warply_custom_gcm_intent_service".equals(sInfo.nonLocalizedLabel)) continue;
                    name = sInfo.name;
                    break;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                WarpUtils.log(e.getMessage());
            }
        }
        return name;
    }

    public static String getAppUuid(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_UUID);
    }

    public static String getLanguage(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_LANGUAGE);
    }

    public static String getMerchantId(Context context) {
        return String.valueOf(WarplyProperty.getWarplyProperty(context, KEY_MERCHANT_ID));
    }

    public static String getLoginType(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_LOGIN_TYPE);
    }

    public static String getDlUrlScheme(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_DL_URL_SCHEME);
    }

    public static boolean isDebugMode(Context context) {
        return Boolean.parseBoolean(WarplyProperty.getWarplyProperty(context, KEY_DEBUG));
    }

    public static String getBaseUrl(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_BASE_URL);
    }

    public static String getVerifyUrl(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_VERIFY_URL);
    }

    public static boolean isSendPackages(Context context) {
        return Boolean.parseBoolean(WarplyProperty.getWarplyProperty(context, KEY_SEND_PACKAGES));
    }

    public static String getWebActionListenerClassName(Context context) {
        return WarplyProperty.getWarplyProperty(context, KEY_WEB_ACTION_HANDLER);
    }

    public static int getProgressColor(Context context) {
        int resId;
        String resName = WarplyProperty.getWarplyProperty(context, KEY_PROGRESS_COLOR);
        if (!TextUtils.isEmpty((CharSequence)resName) && (resId = context.getResources().getIdentifier(resName, "color", context.getPackageName())) > 0) {
            return ContextCompat.getColor((Context)context, (int)resId);
        }
        int color2 = Color.parseColor((String)"#384047");
        int primaryColor = WarplyProperty.getPrimaryColor(context, color2);
        return primaryColor != -1 && primaryColor != 0 ? primaryColor : color2;
    }

    @NonNull
    public static Drawable getProgressDrawable(Context context) {
        int resId;
        String resName = WarplyProperty.getWarplyProperty(context, KEY_PROGRESS_DRAWABLE);
        if (!TextUtils.isEmpty((CharSequence)resName) && (resId = context.getResources().getIdentifier(resName, "drawable", context.getPackageName())) > 0) {
            return ContextCompat.getDrawable((Context)context, (int)resId);
        }
        return WarplyProperty.getLauncherIcon(context, (Drawable)new BitmapDrawable(context.getResources(), WarpUtils.getWarplyLogo()));
    }

    public static int getPushColor(Context context) {
        int resId;
        String resName = WarplyProperty.getWarplyProperty(context, KEY_PUSH_COLOR);
        if (!TextUtils.isEmpty((CharSequence)resName) && (resId = context.getResources().getIdentifier(resName, "color", context.getPackageName())) > 0) {
            return ContextCompat.getColor((Context)context, (int)resId);
        }
        int color2 = Color.parseColor((String)"#384047");
        int primaryColor = WarplyProperty.getPrimaryColor(context, color2);
        return primaryColor != -1 && primaryColor != 0 ? primaryColor : color2;
    }

    @DrawableRes
    public static int getPushIconResId(Context context) {
        int resId;
        String resName = WarplyProperty.getWarplyProperty(context, KEY_PUSH_ICON);
        if (!TextUtils.isEmpty((CharSequence)resName) && (resId = context.getResources().getIdentifier(resName, "drawable", context.getPackageName())) > 0) {
            return resId;
        }
        return 17301514;
    }

    public static Uri getPushSoundUri(Context context) {
        int resId;
        String resName = WarplyProperty.getWarplyProperty(context, KEY_PUSH_SOUND);
        if (!TextUtils.isEmpty((CharSequence)resName) && (resId = context.getResources().getIdentifier(resName, "raw", context.getPackageName())) > 0) {
            return Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + resId));
        }
        return Settings.System.DEFAULT_NOTIFICATION_URI;
    }
}

