/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.PushCampaign;
import ly.warp.sdk.io.request.WarplyInboxRequest;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyServerPreferencesManager;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyAnalyticsManager {
    public static void logEvent(@Nullable String eventPage, String eventId, @Nullable JSONObject metadata) {
        WarplyAnalyticsManager.sendEvent(eventPage, eventId, metadata, false);
    }

    public static void logTrackersEvent(Context context, String eventType, String eventName) {
        if (WarpUtils.getTrackersEnabled(context)) {
            WarplyAnalyticsManager.sendEvent(context, null, eventType.concat(":").concat(eventName), null, false);
        }
    }

    public static void logEventInApp(Context context, @Nullable String eventPage, @NonNull String eventId, @Nullable JSONObject metadata, boolean force) {
        WarplyAnalyticsManager.sendEventInApp(context, eventPage, eventId, metadata, force);
    }

    public static void logUrgentEvent(String eventPage, String eventId, JSONObject metadata) {
        WarplyAnalyticsManager.sendEvent(eventPage, eventId, metadata, true);
    }

    public static void logAppLifeCycleEvent() {
        WarplyAnalyticsManager.sendLifecycleEvent("NB_APP", "session");
    }

    public static void logAppLifeCycleEvent(boolean foreground) {
        WarplyAnalyticsManager.sendLifecycleEvent("NB_APP", "session");
    }

    public static void logUserReceivedPush(String sessionUUID) {
        JSONObject metadata;
        block2: {
            metadata = new JSONObject();
            try {
                metadata.putOpt("session_uuid", (Object)sessionUUID);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        WarplyAnalyticsManager.sendEvent("NB_APP", "NB_PushReceived", metadata, true);
    }

    public static void logUserReceivedPush(PushCampaign pc) {
        JSONObject metadata;
        block2: {
            metadata = new JSONObject();
            try {
                metadata.putOpt("session_uuid", (Object)pc.getSessionUUID());
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        WarplyAnalyticsManager.sendPushReceivedEvent("NB_APP", "NB_PushReceived", metadata, false);
    }

    public static void logUserEngagedPush(JSONObject pushSessionUUID) {
        WarplyAnalyticsManager.sendPushAckEvent("NB_APP", "NB_PushAck", pushSessionUUID, false);
    }

    public static void logUserReceivedPush(JSONObject pushSessionUUID) {
        WarplyAnalyticsManager.sendEvent("NB_APP", "NB_PushReceived", pushSessionUUID, true);
    }

    private static void sendEvent(@Nullable String eventPage, String eventId, @Nullable JSONObject metadata, boolean force) {
        boolean isInAppAnalyticsMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CUSTOM_ANALYTICS);
        if (isInAppAnalyticsMicroAppActive) {
            try {
                JSONObject jObj = new JSONObject();
                if (eventPage != null) {
                    jObj.putOpt("page_id", (Object)eventPage);
                }
                jObj.putOpt("event_id", (Object)eventId);
                jObj.putOpt("time_submitted", (Object)(System.currentTimeMillis() / 1000L));
                if (metadata != null) {
                    jObj.putOpt("action_metadata", (Object)metadata);
                }
                Warply.postMicroappData("inapp_analytics", jObj, force);
            }
            catch (JSONException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else {
            WarpUtils.log("analytics micro-app is not active");
        }
    }

    private static void sendEvent(Context context, @Nullable String eventPage, String eventId, @Nullable JSONObject metadata, boolean force) {
        block7: {
            boolean isInAppAnalyticsMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(context, WarpConstants.MicroApp.CUSTOM_ANALYTICS);
            if (isInAppAnalyticsMicroAppActive) {
                try {
                    JSONObject jObj = new JSONObject();
                    if (eventPage != null) {
                        jObj.putOpt("page_id", (Object)eventPage);
                    }
                    jObj.putOpt("event_id", (Object)eventId);
                    jObj.putOpt("time_submitted", (Object)(System.currentTimeMillis() / 1000L));
                    if (metadata != null) {
                        jObj.putOpt("action_metadata", (Object)metadata);
                    }
                    if (context != null) {
                        Warply.postMicroappData(context, "inapp_analytics", jObj, force);
                    }
                    break block7;
                }
                catch (JSONException e) {
                    if (WarpConstants.DEBUG) {
                        e.printStackTrace();
                    }
                    break block7;
                }
            }
            WarpUtils.log("analytics micro-app is not active");
        }
    }

    private static void sendEventInApp(final Context context, @Nullable String eventPage, final @NonNull String eventId, @Nullable JSONObject metadata, boolean force) {
        boolean isInAppAnalyticsMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CUSTOM_ANALYTICS);
        if (isInAppAnalyticsMicroAppActive) {
            try {
                JSONObject jObj = new JSONObject();
                if (eventPage != null) {
                    jObj.putOpt("page_id", (Object)eventPage);
                }
                jObj.putOpt("event_id", (Object)eventId);
                jObj.putOpt("time_submitted", (Object)(System.currentTimeMillis() / 1000L));
                if (metadata != null) {
                    jObj.putOpt("action_metadata", (Object)metadata);
                }
                Warply.postMicroappData("inapp_analytics", jObj, force);
            }
            catch (JSONException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else {
            WarpUtils.log("analytics micro-app is not active");
        }
        WarplyInboxRequest inboxFilterRequest = new WarplyInboxRequest().setUseCache(false);
        Warply.getInboxInApp(inboxFilterRequest, new CallbackReceiver<CampaignList>(){

            @Override
            public void onSuccess(CampaignList result) {
                Warply.INSTANCE.mInAppCampaigns = result;
                Warply.showInAppCampaign(context, eventId);
            }

            @Override
            public void onFailure(int errorCode) {
            }
        });
    }

    private static void sendPushReceivedEvent(@Nullable String eventPage, String eventId, @Nullable JSONObject metadata, boolean force) {
        boolean isInAppAnalyticsMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CUSTOM_ANALYTICS);
        if (isInAppAnalyticsMicroAppActive) {
            try {
                JSONObject jObj = new JSONObject();
                if (eventPage != null) {
                    jObj.putOpt("page_id", (Object)eventPage);
                }
                jObj.putOpt("event_id", (Object)eventId);
                jObj.putOpt("time_submitted", (Object)(System.currentTimeMillis() / 1000L));
                if (metadata != null) {
                    jObj.putOpt("action_metadata", (Object)metadata);
                }
                Warply.postMicroappPush("inapp_analytics", jObj, force);
            }
            catch (JSONException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else {
            WarpUtils.log("analytics micro-app is not active");
        }
    }

    private static void sendPushAckEvent(@Nullable String eventPage, String eventId, @Nullable JSONObject metadata, boolean force) {
        boolean isInAppAnalyticsMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CUSTOM_ANALYTICS);
        if (isInAppAnalyticsMicroAppActive) {
            try {
                JSONObject jObj = new JSONObject();
                if (eventPage != null) {
                    jObj.putOpt("page_id", (Object)eventPage);
                }
                jObj.putOpt("event_id", (Object)eventId);
                jObj.putOpt("time_submitted", (Object)(System.currentTimeMillis() / 1000L));
                if (metadata != null) {
                    jObj.putOpt("action_metadata", (Object)metadata);
                }
                Warply.postMicroappPushAck("inapp_analytics", jObj, force);
            }
            catch (JSONException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else {
            WarpUtils.log("analytics micro-app is not active");
        }
    }

    private static void sendLifecycleEvent(String eventPage, String eventId) {
        if (Warply.getWarplyContext() == null) {
            return;
        }
        boolean isLifecycleAnalyticsMicroAppActive = WarpUtils.getIsLIFECYCLEANALYTICSENABLED(Warply.getWarplyContext());
        if (!isLifecycleAnalyticsMicroAppActive) {
            WarpUtils.log("session analytics micro-app is not active");
            return;
        }
        WarplyAnalyticsManager.sendEvent(eventPage, eventId, null, true);
    }
}

