/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import ly.warp.sdk.io.callbacks.WarplyHealthCallback;

public class WarplyHealthManager
implements SensorEventListener {
    private long mSteps = 0L;
    private static SensorManager mSensorManager;
    private static Sensor mSensor;
    private static WarplyHealthManager mWarplyHealthManagerInstance;
    private static final int ACCEL_RING_SIZE = 50;
    private static final int VEL_RING_SIZE = 10;
    private static final float STEP_THRESHOLD = 20.0f;
    private static final int STEP_DELAY_NS = 250000000;
    private int accelRingCounter = 0;
    private float[] accelRingX = new float[50];
    private float[] accelRingY = new float[50];
    private float[] accelRingZ = new float[50];
    private int velRingCounter = 0;
    private float[] velRing = new float[10];
    private long lastStepTimeNs = 0L;
    private float oldVelocityEstimate = 0.0f;
    private static WarplyHealthCallback mHealthCallback;

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 1) {
            this.updateSteps(sensorEvent.timestamp, sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2]);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    public static WarplyHealthManager getInstance(Context context) {
        if (mWarplyHealthManagerInstance == null) {
            mWarplyHealthManagerInstance = new WarplyHealthManager();
            mSensorManager = (SensorManager)context.getSystemService("sensor");
            mSensor = mSensorManager.getDefaultSensor(1);
        }
        return mWarplyHealthManagerInstance;
    }

    public static WarplyHealthManager getInstance(Context context, WarplyHealthCallback callback) {
        if (mWarplyHealthManagerInstance == null) {
            mWarplyHealthManagerInstance = new WarplyHealthManager();
            mSensorManager = (SensorManager)context.getSystemService("sensor");
            mSensor = mSensorManager.getDefaultSensor(1);
            mHealthCallback = callback;
        }
        return mWarplyHealthManagerInstance;
    }

    public void registerStepSensor() {
        mSensorManager.registerListener((SensorEventListener)mWarplyHealthManagerInstance, mSensor, 1);
    }

    public void unregisterStepSensor() {
        mSensorManager.unregisterListener((SensorEventListener)mWarplyHealthManagerInstance);
    }

    private void updateSteps(long timeNs, float x, float y, float z) {
        float[] currentAccel = new float[]{x, y, z};
        ++this.accelRingCounter;
        this.accelRingX[this.accelRingCounter % 50] = currentAccel[0];
        this.accelRingY[this.accelRingCounter % 50] = currentAccel[1];
        this.accelRingZ[this.accelRingCounter % 50] = currentAccel[2];
        float[] worldZ = new float[]{this.sum(this.accelRingX) / (float)Math.min(this.accelRingCounter, 50), this.sum(this.accelRingY) / (float)Math.min(this.accelRingCounter, 50), this.sum(this.accelRingZ) / (float)Math.min(this.accelRingCounter, 50)};
        float normalization_factor = this.norm(worldZ);
        worldZ[0] = worldZ[0] / normalization_factor;
        worldZ[1] = worldZ[1] / normalization_factor;
        worldZ[2] = worldZ[2] / normalization_factor;
        float currentZ = this.dot(worldZ, currentAccel) - normalization_factor;
        ++this.velRingCounter;
        this.velRing[this.velRingCounter % 10] = currentZ;
        float velocityEstimate = this.sum(this.velRing);
        if (velocityEstimate > 20.0f && this.oldVelocityEstimate <= 20.0f && timeNs - this.lastStepTimeNs > 250000000L) {
            ++this.mSteps;
            mHealthCallback.onStepCount(this.mSteps);
            this.lastStepTimeNs = timeNs;
        }
        this.oldVelocityEstimate = velocityEstimate;
    }

    private float sum(float[] array) {
        float retval = 0.0f;
        for (float v : array) {
            retval += v;
        }
        return retval;
    }

    private float[] cross(float[] arrayA, float[] arrayB) {
        float[] retArray = new float[]{arrayA[1] * arrayB[2] - arrayA[2] * arrayB[1], arrayA[2] * arrayB[0] - arrayA[0] * arrayB[2], arrayA[0] * arrayB[1] - arrayA[1] * arrayB[0]};
        return retArray;
    }

    private float norm(float[] array) {
        float retval = 0.0f;
        for (float v : array) {
            retval += v * v;
        }
        return (float)Math.sqrt(retval);
    }

    private float dot(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private float[] normalize(float[] a) {
        float[] retval = new float[a.length];
        float norm = this.norm(a);
        for (int i = 0; i < a.length; ++i) {
            retval[i] = a[i] / norm;
        }
        return retval;
    }
}

