/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.LocationManager;
import android.os.Build;
import androidx.work.WorkManager;
import java.util.List;
import ly.warp.sdk.Warply;
import ly.warp.sdk.dexter.listener.DexterError;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.receivers.ConnectivityChangedReceiver;
import ly.warp.sdk.receivers.LocationChangedReceiver;
import ly.warp.sdk.services.UpdateUserLocationService;
import ly.warp.sdk.utils.PermissionsUtil;
import ly.warp.sdk.utils.WarplyPreferences;

public class WarplyLocationManager {
    private static LocationManager locationManager;
    private static String locationProvider;
    public static Context waprplyContext;

    public static void instantiateLocationManager() {
        waprplyContext = Warply.getWarplyContext();
        locationManager = (LocationManager)Warply.getWarplyContext().getSystemService("location");
        locationProvider = "passive";
    }

    public static void startDefaultReportingLocation(Context act) {
        WarplyLocationManager.instantiateLocationManager();
        WarplyLocationManager.enableConnectivityChangedReceiver();
        WarplyLocationManager.enableLocationChangedReceiver();
        if (locationProvider != null) {
            long defaultMinTime = 60000L;
            float defaultMinDistance = 100.0f;
            Intent activeIntent = new Intent(waprplyContext, LocationChangedReceiver.class);
            final PendingIntent locationListenerPendingIntent = PendingIntent.getBroadcast((Context)waprplyContext, (int)0, (Intent)activeIntent, (int)0x8000000);
            PermissionsUtil.PermissionCallback callback = new PermissionsUtil.PermissionCallback(){

                @Override
                public void onError(DexterError error) {
                    this.onPermissionDenied(null);
                }

                @Override
                public void onPermissionDenied(List<PermissionDeniedResponse> denied) {
                    if (denied != null && denied.size() < 2) {
                        this.onPermissionsGranted();
                    }
                }

                @Override
                public void onPermissionsGranted() {
                    try {
                        locationManager.requestLocationUpdates(locationProvider, 60000L, 100.0f, locationListenerPendingIntent);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            };
            try {
                new PermissionsUtil(act, callback, "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION").requestPermissions();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void stopReportingLocation(Context wContext) {
        if (locationManager != null) {
            if (Build.VERSION.SDK_INT >= 31) {
                locationManager.removeUpdates(PendingIntent.getBroadcast((Context)Warply.getWarplyContext(), (int)0, (Intent)new Intent(Warply.getWarplyContext(), LocationChangedReceiver.class), (int)0xA000000));
            } else {
                locationManager.removeUpdates(PendingIntent.getBroadcast((Context)Warply.getWarplyContext(), (int)0, (Intent)new Intent(Warply.getWarplyContext(), LocationChangedReceiver.class), (int)0x8000000));
            }
        }
        WarplyLocationManager.disableLocationChangedReceiver(wContext);
        WarplyLocationManager.disableUpdateLocationService(wContext);
    }

    public static void startReportingLocation(Context wContext, final String newProvider, final long minTime, final float minDistance) {
        if (new WarplyPreferences(wContext).getLocationChangedReceiverStatus().equals("off")) {
            WarplyLocationManager.enableLocationChangedReceiver();
        }
        if (wContext != null) {
            final PendingIntent locationListenerPendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)wContext, (int)0, (Intent)new Intent(wContext, LocationChangedReceiver.class), (int)0xA000000) : PendingIntent.getBroadcast((Context)wContext, (int)0, (Intent)new Intent(wContext, LocationChangedReceiver.class), (int)0x8000000);
            final LocationManager lm = (LocationManager)wContext.getSystemService("location");
            if (lm != null) {
                lm.removeUpdates(locationListenerPendingIntent);
                try {
                    PermissionsUtil.PermissionCallback callback = new PermissionsUtil.PermissionCallback(){

                        @Override
                        public void onError(DexterError error) {
                            this.onPermissionDenied(null);
                        }

                        @Override
                        public void onPermissionDenied(List<PermissionDeniedResponse> denied) {
                            if (denied != null && denied.size() < 2) {
                                this.onPermissionsGranted();
                            }
                        }

                        @Override
                        public void onPermissionsGranted() {
                            try {
                                if (lm.isProviderEnabled(newProvider)) {
                                    lm.requestLocationUpdates(newProvider, minTime, minDistance, locationListenerPendingIntent);
                                } else {
                                    Criteria criteria = new Criteria();
                                    criteria.setAltitudeRequired(false);
                                    criteria.setBearingRequired(false);
                                    criteria.setSpeedRequired(false);
                                    if (newProvider.equals("gps")) {
                                        criteria.setAccuracy(1);
                                    } else {
                                        criteria.setAccuracy(2);
                                    }
                                    String bestProvider = lm.getBestProvider(criteria, true);
                                    if (bestProvider == null || criteria.getAccuracy() == 2 && bestProvider.equals("gps")) {
                                        lm.requestLocationUpdates("passive", minTime, minDistance, locationListenerPendingIntent);
                                    } else {
                                        lm.requestLocationUpdates(bestProvider, minTime, minDistance, locationListenerPendingIntent);
                                    }
                                }
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                    };
                    new PermissionsUtil(wContext, callback, "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION").requestPermissions();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    public static void regulateLocationWithNewSettings(Context wContext, String newProvider, long minTime, float minDistance) {
        if (wContext != null) {
            if (newProvider.equals("off")) {
                WarplyLocationManager.stopReportingLocation(wContext);
            } else {
                WarplyLocationManager.startReportingLocation(wContext, newProvider, minTime, minDistance);
            }
        }
    }

    private static void enableLocationChangedReceiver() {
        Warply.getWarplyContext().getPackageManager().setComponentEnabledSetting(new ComponentName(Warply.getWarplyContext(), LocationChangedReceiver.class), 1, 1);
        new WarplyPreferences(Warply.getWarplyContext()).saveLocationChangedReceiverStatus("on");
    }

    private static void disableLocationChangedReceiver(Context wContext) {
        wContext.getPackageManager().setComponentEnabledSetting(new ComponentName(wContext, LocationChangedReceiver.class), 2, 1);
        new WarplyPreferences(wContext).saveLocationChangedReceiverStatus("off");
        WorkManager.getInstance((Context)Warply.getWarplyContext()).cancelAllWorkByTag("LOCATION_KEY");
    }

    private static void enableConnectivityChangedReceiver() {
        waprplyContext.getPackageManager().setComponentEnabledSetting(new ComponentName(waprplyContext, ConnectivityChangedReceiver.class), 1, 1);
    }

    public static void disableConnectivityChangedReceiver(Context wContext) {
        wContext.getPackageManager().setComponentEnabledSetting(new ComponentName(wContext, ConnectivityChangedReceiver.class), 2, 1);
    }

    private static void disableUpdateLocationService(Context wContext) {
        wContext.stopService(new Intent(wContext, UpdateUserLocationService.class));
        new WarplyPreferences(wContext).saveUpdateLocationServiceStatus("off");
    }

    public static LocationManager getLocationManager() {
        return locationManager;
    }
}

